/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DelegatingServerAuthenticationEntryPoint
implements ServerAuthenticationEntryPoint {
    private final List<DelegateEntry> entryPoints;
    private ServerAuthenticationEntryPoint defaultEntryPoint = (exchange2, e) -> {
        exchange2.getResponse().setStatusCode(HttpStatus.UNAUTHORIZED);
        return exchange2.getResponse().setComplete();
    };

    public DelegatingServerAuthenticationEntryPoint(DelegateEntry ... entryPoints) {
        this(Arrays.asList(entryPoints));
    }

    public DelegatingServerAuthenticationEntryPoint(List<DelegateEntry> entryPoints) {
        Assert.notEmpty(entryPoints, "entryPoints cannot be null");
        this.entryPoints = entryPoints;
    }

    @Override
    public Mono<Void> commence(ServerWebExchange exchange2, AuthenticationException e) {
        return Flux.fromIterable(this.entryPoints).filterWhen(entry -> this.isMatch(exchange2, (DelegateEntry)entry)).next().map(entry -> entry.getEntryPoint()).defaultIfEmpty(this.defaultEntryPoint).flatMap(entryPoint -> entryPoint.commence(exchange2, e));
    }

    private Mono<Boolean> isMatch(ServerWebExchange exchange2, DelegateEntry entry) {
        ServerWebExchangeMatcher matcher = entry.getMatcher();
        return matcher.matches(exchange2).map(result -> result.isMatch());
    }

    public void setDefaultEntryPoint(ServerAuthenticationEntryPoint defaultEntryPoint) {
        this.defaultEntryPoint = defaultEntryPoint;
    }

    public static class DelegateEntry {
        private final ServerWebExchangeMatcher matcher;
        private final ServerAuthenticationEntryPoint entryPoint;

        public DelegateEntry(ServerWebExchangeMatcher matcher, ServerAuthenticationEntryPoint entryPoint) {
            this.matcher = matcher;
            this.entryPoint = entryPoint;
        }

        public ServerWebExchangeMatcher getMatcher() {
            return this.matcher;
        }

        public ServerAuthenticationEntryPoint getEntryPoint() {
            return this.entryPoint;
        }
    }
}

