/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.reactive.result.view;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.web.reactive.result.view.RequestDataValueProcessor;
import org.springframework.web.server.ServerWebExchange;

public class CsrfRequestDataValueProcessor
implements RequestDataValueProcessor {
    public static final String DEFAULT_CSRF_ATTR_NAME = "_csrf";
    private static final Pattern DISABLE_CSRF_TOKEN_PATTERN = Pattern.compile("(?i)^(GET|HEAD|TRACE|OPTIONS)$");
    private static final String DISABLE_CSRF_TOKEN_ATTR = "DISABLE_CSRF_TOKEN_ATTR";

    @Override
    public String processAction(ServerWebExchange exchange2, String action, String httpMethod) {
        if (httpMethod != null && DISABLE_CSRF_TOKEN_PATTERN.matcher(httpMethod).matches()) {
            exchange2.getAttributes().put(DISABLE_CSRF_TOKEN_ATTR, Boolean.TRUE);
        } else {
            exchange2.getAttributes().remove(DISABLE_CSRF_TOKEN_ATTR);
        }
        return action;
    }

    @Override
    public String processFormFieldValue(ServerWebExchange exchange2, String name, String value, String type) {
        return value;
    }

    @Override
    @NonNull
    public Map<String, String> getExtraHiddenFields(ServerWebExchange exchange2) {
        if (Boolean.TRUE.equals(exchange2.getAttribute(DISABLE_CSRF_TOKEN_ATTR))) {
            exchange2.getAttributes().remove(DISABLE_CSRF_TOKEN_ATTR);
            return Collections.emptyMap();
        }
        CsrfToken token = (CsrfToken)exchange2.getAttribute(DEFAULT_CSRF_ATTR_NAME);
        if (token == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(token.getParameterName(), token.getToken());
    }

    @Override
    public String processUrl(ServerWebExchange exchange2, String url) {
        return url;
    }
}

