/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.firewall;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.firewall.FirewalledRequest;

final class RequestWrapper
extends FirewalledRequest {
    private final String strippedServletPath;
    private final String strippedPathInfo;
    private boolean stripPaths = true;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        this.strippedServletPath = this.strip(request.getServletPath());
        String pathInfo = this.strip(request.getPathInfo());
        if (pathInfo != null && pathInfo.length() == 0) {
            pathInfo = null;
        }
        this.strippedPathInfo = pathInfo;
    }

    private String strip(String path2) {
        int doubleSlashIndex;
        if (path2 == null) {
            return null;
        }
        int scIndex = path2.indexOf(59);
        if (scIndex < 0 && (doubleSlashIndex = path2.indexOf("//")) < 0) {
            return path2;
        }
        StringTokenizer st = new StringTokenizer(path2, "/");
        StringBuilder stripped = new StringBuilder(path2.length());
        if (path2.charAt(0) == '/') {
            stripped.append('/');
        }
        while (st.hasMoreTokens()) {
            String segment = st.nextToken();
            scIndex = segment.indexOf(59);
            if (scIndex >= 0) {
                segment = segment.substring(0, scIndex);
            }
            stripped.append(segment).append('/');
        }
        if (path2.charAt(path2.length() - 1) != '/') {
            stripped.deleteCharAt(stripped.length() - 1);
        }
        return stripped.toString();
    }

    @Override
    public String getPathInfo() {
        return this.stripPaths ? this.strippedPathInfo : super.getPathInfo();
    }

    @Override
    public String getServletPath() {
        return this.stripPaths ? this.strippedServletPath : super.getServletPath();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path2) {
        return this.stripPaths ? new FirewalledRequestAwareRequestDispatcher(path2) : super.getRequestDispatcher(path2);
    }

    @Override
    public void reset() {
        this.stripPaths = false;
    }

    private class FirewalledRequestAwareRequestDispatcher
    implements RequestDispatcher {
        private final String path;

        public FirewalledRequestAwareRequestDispatcher(String path2) {
            this.path = path2;
        }

        @Override
        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            RequestWrapper.this.reset();
            this.getDelegateDispatcher().forward(request, response);
        }

        @Override
        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.getDelegateDispatcher().include(request, response);
        }

        private RequestDispatcher getDelegateDispatcher() {
            return RequestWrapper.super.getRequestDispatcher(this.path);
        }
    }
}

