/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.reactive.server;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.server.csrf.CsrfWebFilter;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.test.web.reactive.server.MockServerConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import reactor.core.publisher.Mono;

public class SecurityMockServerConfigurers {
    public static MockServerConfigurer springSecurity() {
        return new MockServerConfigurer(){

            @Override
            public void beforeServerCreated(WebHttpHandlerBuilder builder) {
                builder.filters(filters -> filters.add(0, new MutatorFilter()));
            }
        };
    }

    public static <T extends WebTestClientConfigurer & MockServerConfigurer> T mockAuthentication(Authentication authentication) {
        return (T)new MutatorWebTestClientConfigurer(() -> Mono.just(authentication).map(SecurityContextImpl::new));
    }

    public static <T extends WebTestClientConfigurer & MockServerConfigurer> T mockUser(UserDetails userDetails) {
        return SecurityMockServerConfigurers.mockAuthentication(new UsernamePasswordAuthenticationToken(userDetails, userDetails.getPassword(), userDetails.getAuthorities()));
    }

    public static UserExchangeMutator mockUser() {
        return SecurityMockServerConfigurers.mockUser("user");
    }

    public static UserExchangeMutator mockUser(String username) {
        return new UserExchangeMutator(username);
    }

    public static CsrfMutator csrf() {
        return new CsrfMutator();
    }

    private static class MutatorFilter
    implements WebFilter {
        public static final String ATTRIBUTE_NAME = "context";

        private MutatorFilter() {
        }

        @Override
        public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain webFilterChain) {
            Supplier context = (Supplier)exchange2.getAttribute(ATTRIBUTE_NAME);
            if (context != null) {
                exchange2.getAttributes().remove(ATTRIBUTE_NAME);
                return webFilterChain.filter(exchange2).subscriberContext(ReactiveSecurityContextHolder.withSecurityContext((Mono)context.get()));
            }
            return webFilterChain.filter(exchange2);
        }
    }

    private static class SetupMutatorFilter
    implements WebFilter {
        private final Supplier<Mono<SecurityContext>> context;

        private SetupMutatorFilter(Supplier<Mono<SecurityContext>> context) {
            this.context = context;
        }

        @Override
        public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain webFilterChain) {
            exchange2.getAttributes().computeIfAbsent("context", key -> this.context);
            return webFilterChain.filter(exchange2);
        }
    }

    private static class MutatorWebTestClientConfigurer
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private final Supplier<Mono<SecurityContext>> context;

        private MutatorWebTestClientConfigurer(Supplier<Mono<SecurityContext>> context) {
            this.context = context;
        }

        @Override
        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            builder.filters(this.addSetupMutatorFilter());
        }

        @Override
        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder webHttpHandlerBuilder, @Nullable ClientHttpConnector clientHttpConnector) {
            webHttpHandlerBuilder.filters(this.addSetupMutatorFilter());
        }

        private Consumer<List<WebFilter>> addSetupMutatorFilter() {
            return filters -> filters.add(0, new SetupMutatorFilter(this.context));
        }
    }

    public static class UserExchangeMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private final User.UserBuilder userBuilder;

        private UserExchangeMutator(String username) {
            this.userBuilder = User.withUsername(username);
            this.password("password");
            this.roles("USER");
        }

        public UserExchangeMutator password(String password) {
            this.userBuilder.password(password);
            return this;
        }

        public UserExchangeMutator roles(String ... roles) {
            this.userBuilder.roles(roles);
            return this;
        }

        public UserExchangeMutator authorities(GrantedAuthority ... authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator authorities(Collection<? extends GrantedAuthority> authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator authorities(String ... authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator accountExpired(boolean accountExpired) {
            this.userBuilder.accountExpired(accountExpired);
            return this;
        }

        public UserExchangeMutator accountLocked(boolean accountLocked) {
            this.userBuilder.accountLocked(accountLocked);
            return this;
        }

        public UserExchangeMutator credentialsExpired(boolean credentialsExpired) {
            this.userBuilder.credentialsExpired(credentialsExpired);
            return this;
        }

        public UserExchangeMutator disabled(boolean disabled) {
            this.userBuilder.disabled(disabled);
            return this;
        }

        @Override
        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            ((MockServerConfigurer)this.configurer()).beforeServerCreated(builder);
        }

        @Override
        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
            ((MockServerConfigurer)this.configurer()).afterConfigureAdded(serverSpec);
        }

        @Override
        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder webHttpHandlerBuilder, @Nullable ClientHttpConnector clientHttpConnector) {
            ((WebTestClientConfigurer)((Object)((MockServerConfigurer)this.configurer()))).afterConfigurerAdded(builder, webHttpHandlerBuilder, clientHttpConnector);
        }

        private <T extends WebTestClientConfigurer & MockServerConfigurer> T configurer() {
            return SecurityMockServerConfigurers.mockUser(this.userBuilder.build());
        }
    }

    public static class CsrfMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        @Override
        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
            CsrfWebFilter filter = new CsrfWebFilter();
            filter.setRequireCsrfProtectionMatcher(e -> ServerWebExchangeMatcher.MatchResult.notMatch());
            httpHandlerBuilder.filters(filters -> filters.add(0, filter));
        }

        @Override
        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
        }

        @Override
        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
        }

        private CsrfMutator() {
        }
    }
}

