/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class LdapServerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String CONTEXT_SOURCE_CLASS = "org.springframework.security.ldap.DefaultSpringSecurityContextSource";
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_URL = "url";
    private static final String ATT_PRINCIPAL = "manager-dn";
    private static final String ATT_PASSWORD = "manager-password";
    public static final String ATT_ROOT_SUFFIX = "root";
    private static final String OPT_DEFAULT_ROOT_SUFFIX = "dc=springframework,dc=org";
    public static final String ATT_LDIF_FILE = "ldif";
    private static final String OPT_DEFAULT_LDIF_FILE = "classpath*:*.ldif";
    public static final String ATT_PORT = "port";
    private static final int DEFAULT_PORT = 33389;
    public static final String OPT_DEFAULT_PORT = String.valueOf(33389);

    @Override
    public BeanDefinition parse(Element elt, ParserContext parserContext) {
        String id;
        RootBeanDefinition contextSource;
        String url = elt.getAttribute(ATT_URL);
        if (!StringUtils.hasText(url)) {
            contextSource = this.createEmbeddedServer(elt, parserContext);
        } else {
            contextSource = new RootBeanDefinition();
            contextSource.setBeanClassName(CONTEXT_SOURCE_CLASS);
            contextSource.getConstructorArgumentValues().addIndexedArgumentValue(0, url);
        }
        contextSource.setSource(parserContext.extractSource(elt));
        String managerDn = elt.getAttribute(ATT_PRINCIPAL);
        String managerPassword = elt.getAttribute(ATT_PASSWORD);
        if (StringUtils.hasText(managerDn)) {
            if (!StringUtils.hasText(managerPassword)) {
                parserContext.getReaderContext().error("You must specify the manager-password if you supply a " + managerDn, elt);
            }
            contextSource.getPropertyValues().addPropertyValue("userDn", managerDn);
            contextSource.getPropertyValues().addPropertyValue("password", managerPassword);
        }
        String contextSourceId = StringUtils.hasText(id = elt.getAttribute("id")) ? id : "org.springframework.security.securityContextSource";
        parserContext.getRegistry().registerBeanDefinition(contextSourceId, contextSource);
        return null;
    }

    private RootBeanDefinition createEmbeddedServer(Element element, ParserContext parserContext) {
        String port;
        Object source = parserContext.extractSource(element);
        String suffix = element.getAttribute(ATT_ROOT_SUFFIX);
        if (!StringUtils.hasText(suffix)) {
            suffix = OPT_DEFAULT_ROOT_SUFFIX;
        }
        if (!StringUtils.hasText(port = element.getAttribute(ATT_PORT))) {
            port = this.getDefaultPort();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using default port of " + port);
            }
        }
        String url = "ldap://127.0.0.1:" + port + "/" + suffix;
        BeanDefinitionBuilder contextSource = BeanDefinitionBuilder.rootBeanDefinition(CONTEXT_SOURCE_CLASS);
        contextSource.addConstructorArgValue(url);
        contextSource.addPropertyValue("userDn", "uid=admin,ou=system");
        contextSource.addPropertyValue("password", "secret");
        RootBeanDefinition apacheContainer = new RootBeanDefinition("org.springframework.security.ldap.server.ApacheDSContainer", null, null);
        apacheContainer.setSource(source);
        apacheContainer.getConstructorArgumentValues().addGenericArgumentValue(suffix);
        String ldifs = element.getAttribute(ATT_LDIF_FILE);
        if (!StringUtils.hasText(ldifs)) {
            ldifs = OPT_DEFAULT_LDIF_FILE;
        }
        apacheContainer.getConstructorArgumentValues().addGenericArgumentValue(ldifs);
        apacheContainer.getPropertyValues().addPropertyValue(ATT_PORT, port);
        this.logger.info("Embedded LDAP server bean definition created for URL: " + url);
        if (parserContext.getRegistry().containsBeanDefinition("org.springframework.security.apacheDirectoryServerContainer")) {
            parserContext.getReaderContext().error("Only one embedded server bean is allowed per application context", element);
        }
        parserContext.getRegistry().registerBeanDefinition("org.springframework.security.apacheDirectoryServerContainer", apacheContainer);
        return (RootBeanDefinition)contextSource.getBeanDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultPort() {
        ServerSocket serverSocket = null;
        try {
            try {
                serverSocket = new ServerSocket(33389);
            }
            catch (IOException e) {
                try {
                    serverSocket = new ServerSocket(0);
                }
                catch (IOException e2) {
                    String string = String.valueOf(33389);
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return string;
                }
            }
            String string = String.valueOf(serverSocket.getLocalPort());
            return string;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

