/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.FilterComparator;
import org.springframework.security.config.annotation.web.configurers.AnonymousConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.CorsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.config.annotation.web.configurers.JeeConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.PortMapperConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.RequestCacheConfigurer;
import org.springframework.security.config.annotation.web.configurers.SecurityContextConfigurer;
import org.springframework.security.config.annotation.web.configurers.ServletApiConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.X509Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.openid.OpenIDLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public final class HttpSecurity
extends AbstractConfiguredSecurityBuilder<DefaultSecurityFilterChain, HttpSecurity>
implements SecurityBuilder<DefaultSecurityFilterChain>,
HttpSecurityBuilder<HttpSecurity> {
    private final RequestMatcherConfigurer requestMatcherConfigurer;
    private List<Filter> filters = new ArrayList<Filter>();
    private RequestMatcher requestMatcher = AnyRequestMatcher.INSTANCE;
    private FilterComparator comparator = new FilterComparator();

    public HttpSecurity(ObjectPostProcessor<Object> objectPostProcessor, AuthenticationManagerBuilder authenticationBuilder, Map<Class<? extends Object>, Object> sharedObjects) {
        super(objectPostProcessor);
        Assert.notNull((Object)authenticationBuilder, "authenticationBuilder cannot be null");
        this.setSharedObject(AuthenticationManagerBuilder.class, authenticationBuilder);
        for (Map.Entry<Class<? extends Object>, Object> entry : sharedObjects.entrySet()) {
            this.setSharedObject(entry.getKey(), entry.getValue());
        }
        ApplicationContext context = (ApplicationContext)sharedObjects.get(ApplicationContext.class);
        this.requestMatcherConfigurer = new RequestMatcherConfigurer(context);
    }

    private ApplicationContext getContext() {
        return this.getSharedObject(ApplicationContext.class);
    }

    public OpenIDLoginConfigurer<HttpSecurity> openidLogin() throws Exception {
        return this.getOrApply(new OpenIDLoginConfigurer());
    }

    public HeadersConfigurer<HttpSecurity> headers() throws Exception {
        return this.getOrApply(new HeadersConfigurer());
    }

    public CorsConfigurer<HttpSecurity> cors() throws Exception {
        return this.getOrApply(new CorsConfigurer());
    }

    public SessionManagementConfigurer<HttpSecurity> sessionManagement() throws Exception {
        return this.getOrApply(new SessionManagementConfigurer());
    }

    public PortMapperConfigurer<HttpSecurity> portMapper() throws Exception {
        return this.getOrApply(new PortMapperConfigurer());
    }

    public JeeConfigurer<HttpSecurity> jee() throws Exception {
        return this.getOrApply(new JeeConfigurer());
    }

    public X509Configurer<HttpSecurity> x509() throws Exception {
        return this.getOrApply(new X509Configurer());
    }

    public RememberMeConfigurer<HttpSecurity> rememberMe() throws Exception {
        return this.getOrApply(new RememberMeConfigurer());
    }

    public ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry authorizeRequests() throws Exception {
        ApplicationContext context = this.getContext();
        return this.getOrApply(new ExpressionUrlAuthorizationConfigurer(context)).getRegistry();
    }

    public RequestCacheConfigurer<HttpSecurity> requestCache() throws Exception {
        return this.getOrApply(new RequestCacheConfigurer());
    }

    public ExceptionHandlingConfigurer<HttpSecurity> exceptionHandling() throws Exception {
        return this.getOrApply(new ExceptionHandlingConfigurer());
    }

    public SecurityContextConfigurer<HttpSecurity> securityContext() throws Exception {
        return this.getOrApply(new SecurityContextConfigurer());
    }

    public ServletApiConfigurer<HttpSecurity> servletApi() throws Exception {
        return this.getOrApply(new ServletApiConfigurer());
    }

    public CsrfConfigurer<HttpSecurity> csrf() throws Exception {
        ApplicationContext context = this.getContext();
        return this.getOrApply(new CsrfConfigurer(context));
    }

    public LogoutConfigurer<HttpSecurity> logout() throws Exception {
        return this.getOrApply(new LogoutConfigurer());
    }

    public AnonymousConfigurer<HttpSecurity> anonymous() throws Exception {
        return this.getOrApply(new AnonymousConfigurer());
    }

    public FormLoginConfigurer<HttpSecurity> formLogin() throws Exception {
        return this.getOrApply(new FormLoginConfigurer());
    }

    public OAuth2LoginConfigurer<HttpSecurity> oauth2Login() throws Exception {
        return this.getOrApply(new OAuth2LoginConfigurer());
    }

    public ChannelSecurityConfigurer.ChannelRequestMatcherRegistry requiresChannel() throws Exception {
        ApplicationContext context = this.getContext();
        return this.getOrApply(new ChannelSecurityConfigurer(context)).getRegistry();
    }

    public HttpBasicConfigurer<HttpSecurity> httpBasic() throws Exception {
        return this.getOrApply(new HttpBasicConfigurer());
    }

    @Override
    public <C> void setSharedObject(Class<C> sharedType, C object) {
        super.setSharedObject(sharedType, object);
    }

    @Override
    protected void beforeConfigure() throws Exception {
        this.setSharedObject(AuthenticationManager.class, this.getAuthenticationRegistry().build());
    }

    @Override
    protected DefaultSecurityFilterChain performBuild() throws Exception {
        Collections.sort(this.filters, this.comparator);
        return new DefaultSecurityFilterChain(this.requestMatcher, this.filters);
    }

    @Override
    public HttpSecurity authenticationProvider(AuthenticationProvider authenticationProvider) {
        this.getAuthenticationRegistry().authenticationProvider(authenticationProvider);
        return this;
    }

    @Override
    public HttpSecurity userDetailsService(UserDetailsService userDetailsService) throws Exception {
        this.getAuthenticationRegistry().userDetailsService(userDetailsService);
        return this;
    }

    private AuthenticationManagerBuilder getAuthenticationRegistry() {
        return this.getSharedObject(AuthenticationManagerBuilder.class);
    }

    @Override
    public HttpSecurity addFilterAfter(Filter filter, Class<? extends Filter> afterFilter) {
        this.comparator.registerAfter(filter.getClass(), afterFilter);
        return this.addFilter(filter);
    }

    @Override
    public HttpSecurity addFilterBefore(Filter filter, Class<? extends Filter> beforeFilter) {
        this.comparator.registerBefore(filter.getClass(), beforeFilter);
        return this.addFilter(filter);
    }

    @Override
    public HttpSecurity addFilter(Filter filter) {
        Class<?> filterClass = filter.getClass();
        if (!this.comparator.isRegistered(filterClass)) {
            throw new IllegalArgumentException("The Filter class " + filterClass.getName() + " does not have a registered order and cannot be added without a specified order. Consider using addFilterBefore or addFilterAfter instead.");
        }
        this.filters.add(filter);
        return this;
    }

    public HttpSecurity addFilterAt(Filter filter, Class<? extends Filter> atFilter) {
        this.comparator.registerAt(filter.getClass(), atFilter);
        return this.addFilter(filter);
    }

    public RequestMatcherConfigurer requestMatchers() {
        return this.requestMatcherConfigurer;
    }

    public HttpSecurity requestMatcher(RequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
        return this;
    }

    public HttpSecurity antMatcher(String antPattern) {
        return this.requestMatcher(new AntPathRequestMatcher(antPattern));
    }

    public HttpSecurity mvcMatcher(String mvcPattern) {
        HandlerMappingIntrospector introspector = new HandlerMappingIntrospector(this.getContext());
        return this.requestMatcher(new MvcRequestMatcher(introspector, mvcPattern));
    }

    public HttpSecurity regexMatcher(String pattern) {
        return this.requestMatcher(new RegexRequestMatcher(pattern, null));
    }

    private <C extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity>> C getOrApply(C configurer) throws Exception {
        SecurityConfigurerAdapter existingConfig = (SecurityConfigurerAdapter)this.getConfigurer(configurer.getClass());
        if (existingConfig != null) {
            return (C)existingConfig;
        }
        return this.apply(configurer);
    }

    public class RequestMatcherConfigurer
    extends AbstractRequestMatcherRegistry<RequestMatcherConfigurer> {
        protected List<RequestMatcher> matchers = new ArrayList<RequestMatcher>();

        private RequestMatcherConfigurer(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        @Override
        public MvcMatchersRequestMatcherConfigurer mvcMatchers(HttpMethod method2, String ... mvcPatterns) {
            List<MvcRequestMatcher> mvcMatchers = this.createMvcMatchers(method2, mvcPatterns);
            this.setMatchers(mvcMatchers);
            return new MvcMatchersRequestMatcherConfigurer(HttpSecurity.this.getContext(), mvcMatchers);
        }

        @Override
        public MvcMatchersRequestMatcherConfigurer mvcMatchers(String ... patterns) {
            return this.mvcMatchers((HttpMethod)null, patterns);
        }

        @Override
        protected RequestMatcherConfigurer chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            this.setMatchers(requestMatchers);
            return this;
        }

        private void setMatchers(List<? extends RequestMatcher> requestMatchers) {
            this.matchers.addAll(requestMatchers);
            HttpSecurity.this.requestMatcher(new OrRequestMatcher(this.matchers));
        }

        public HttpSecurity and() {
            return HttpSecurity.this;
        }
    }

    public final class MvcMatchersRequestMatcherConfigurer
    extends RequestMatcherConfigurer {
        private MvcMatchersRequestMatcherConfigurer(ApplicationContext context, List<MvcRequestMatcher> matchers) {
            super(context);
            this.matchers = new ArrayList<MvcRequestMatcher>(matchers);
        }

        public RequestMatcherConfigurer servletPath(String servletPath) {
            for (RequestMatcher matcher : this.matchers) {
                ((MvcRequestMatcher)matcher).setServletPath(servletPath);
            }
            return this;
        }
    }
}

