/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public abstract class AbstractRequestMatcherRegistry<C> {
    private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";
    private static final RequestMatcher ANY_REQUEST = AnyRequestMatcher.INSTANCE;
    private ApplicationContext context;

    protected final void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    protected final ApplicationContext getApplicationContext() {
        return this.context;
    }

    public C anyRequest() {
        return this.requestMatchers(ANY_REQUEST);
    }

    public C antMatchers(HttpMethod method2) {
        return this.antMatchers(method2, "/**");
    }

    public C antMatchers(HttpMethod method2, String ... antPatterns) {
        return this.chainRequestMatchers(RequestMatchers.antMatchers(method2, antPatterns));
    }

    public C antMatchers(String ... antPatterns) {
        return this.chainRequestMatchers(RequestMatchers.antMatchers(antPatterns));
    }

    public abstract C mvcMatchers(String ... var1);

    public abstract C mvcMatchers(HttpMethod var1, String ... var2);

    protected final List<MvcRequestMatcher> createMvcMatchers(HttpMethod method2, String ... mvcPatterns) {
        boolean isServlet30 = ClassUtils.isPresent("javax.servlet.ServletRegistration", this.getClass().getClassLoader());
        ObjectPostProcessor opp = this.context.getBean(ObjectPostProcessor.class);
        if (!this.context.containsBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
            throw new NoSuchBeanDefinitionException("A Bean named mvcHandlerMappingIntrospector of type " + HandlerMappingIntrospector.class.getName() + " is required to use MvcRequestMatcher. Please ensure Spring Security & Spring MVC are configured in a shared ApplicationContext.");
        }
        HandlerMappingIntrospector introspector = this.context.getBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME, HandlerMappingIntrospector.class);
        ArrayList<MvcRequestMatcher> matchers = new ArrayList<MvcRequestMatcher>(mvcPatterns.length);
        for (String mvcPattern : mvcPatterns) {
            MvcRequestMatcher matcher = new MvcRequestMatcher(introspector, mvcPattern);
            if (isServlet30) {
                opp.postProcess(matcher);
            }
            if (method2 != null) {
                matcher.setMethod(method2);
            }
            matchers.add(matcher);
        }
        return matchers;
    }

    public C regexMatchers(HttpMethod method2, String ... regexPatterns) {
        return this.chainRequestMatchers(RequestMatchers.regexMatchers(method2, regexPatterns));
    }

    public C regexMatchers(String ... regexPatterns) {
        return this.chainRequestMatchers(RequestMatchers.regexMatchers(regexPatterns));
    }

    public C requestMatchers(RequestMatcher ... requestMatchers) {
        return this.chainRequestMatchers(Arrays.asList(requestMatchers));
    }

    protected abstract C chainRequestMatchers(List<RequestMatcher> var1);

    private static final class RequestMatchers {
        public static List<RequestMatcher> antMatchers(HttpMethod httpMethod, String ... antPatterns) {
            String method2 = httpMethod == null ? null : httpMethod.toString();
            ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
            for (String pattern : antPatterns) {
                matchers.add(new AntPathRequestMatcher(pattern, method2));
            }
            return matchers;
        }

        public static List<RequestMatcher> antMatchers(String ... antPatterns) {
            return RequestMatchers.antMatchers(null, antPatterns);
        }

        public static List<RequestMatcher> regexMatchers(HttpMethod httpMethod, String ... regexPatterns) {
            String method2 = httpMethod == null ? null : httpMethod.toString();
            ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
            for (String pattern : regexPatterns) {
                matchers.add(new RegexRequestMatcher(pattern, method2));
            }
            return matchers;
        }

        public static List<RequestMatcher> regexMatchers(String ... regexPatterns) {
            return RequestMatchers.regexMatchers(null, regexPatterns);
        }

        private RequestMatchers() {
        }
    }
}

