/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class AuthorityReactiveAuthorizationManager<T>
implements ReactiveAuthorizationManager<T> {
    private final String authority;

    private AuthorityReactiveAuthorizationManager(String authority) {
        this.authority = authority;
    }

    @Override
    public Mono<AuthorizationDecision> check(Mono<Authentication> authentication, T object) {
        return authentication.filter(a -> a.isAuthenticated()).flatMapIterable(a -> a.getAuthorities()).map(g2 -> g2.getAuthority()).hasElement(this.authority).map(hasAuthority -> new AuthorizationDecision((boolean)hasAuthority)).defaultIfEmpty(new AuthorizationDecision(false));
    }

    public static <T> AuthorityReactiveAuthorizationManager<T> hasAuthority(String authority) {
        Assert.notNull((Object)authority, "authority cannot be null");
        return new AuthorityReactiveAuthorizationManager<T>(authority);
    }

    public static <T> AuthorityReactiveAuthorizationManager<T> hasRole(String role) {
        Assert.notNull((Object)role, "role cannot be null");
        return AuthorityReactiveAuthorizationManager.hasAuthority("ROLE_" + role);
    }
}

