/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ReactiveAuthenticationManagerAdapter
implements ReactiveAuthenticationManager {
    private final AuthenticationManager authenticationManager;

    public ReactiveAuthenticationManagerAdapter(AuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, "authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
    }

    @Override
    public Mono<Authentication> authenticate(Authentication token) {
        return Mono.just(token).publishOn(Schedulers.elastic()).flatMap(t -> {
            try {
                return Mono.just(this.authenticationManager.authenticate((Authentication)t));
            }
            catch (Throwable error) {
                return Mono.error(error);
            }
        }).filter(a -> a.isAuthenticated());
    }
}

