/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class MockMultipartHttpServletRequest
extends MockHttpServletRequest
implements MultipartHttpServletRequest {
    private final MultiValueMap<String, MultipartFile> multipartFiles = new LinkedMultiValueMap<String, MultipartFile>();

    public MockMultipartHttpServletRequest() {
        this(null);
    }

    public MockMultipartHttpServletRequest(@Nullable ServletContext servletContext) {
        super(servletContext);
        this.setMethod("POST");
        this.setContentType("multipart/form-data");
    }

    public void addFile(MultipartFile file) {
        Assert.notNull((Object)file, "MultipartFile must not be null");
        this.multipartFiles.add(file.getName(), file);
    }

    @Override
    public Iterator<String> getFileNames() {
        return this.multipartFiles.keySet().iterator();
    }

    @Override
    public MultipartFile getFile(String name) {
        return this.multipartFiles.getFirst(name);
    }

    @Override
    public List<MultipartFile> getFiles(String name) {
        List multipartFiles = (List)this.multipartFiles.get(name);
        if (multipartFiles != null) {
            return multipartFiles;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, MultipartFile> getFileMap() {
        return this.multipartFiles.toSingleValueMap();
    }

    @Override
    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        return new LinkedMultiValueMap<String, MultipartFile>(this.multipartFiles);
    }

    @Override
    public String getMultipartContentType(String paramOrFileName) {
        MultipartFile file = this.getFile(paramOrFileName);
        if (file != null) {
            return file.getContentType();
        }
        return null;
    }

    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.resolve(this.getMethod());
    }

    @Override
    public HttpHeaders getRequestHeaders() {
        HttpHeaders headers2 = new HttpHeaders();
        Enumeration<String> headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            headers2.put(headerName, (List<String>)Collections.list(this.getHeaders(headerName)));
        }
        return headers2;
    }

    @Override
    public HttpHeaders getMultipartHeaders(String paramOrFileName) {
        String contentType2 = this.getMultipartContentType(paramOrFileName);
        if (contentType2 != null) {
            HttpHeaders headers2 = new HttpHeaders();
            headers2.add("Content-Type", contentType2);
            return headers2;
        }
        return null;
    }
}

