/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client.reactive;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockClientHttpResponse
implements ClientHttpResponse {
    private final HttpStatus status;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap<String, ResponseCookie>();
    private Flux<DataBuffer> body = Flux.empty();
    private final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();

    public MockClientHttpResponse(HttpStatus status) {
        Assert.notNull((Object)status, "HttpStatus is required");
        this.status = status;
    }

    @Override
    public HttpStatus getStatusCode() {
        return this.status;
    }

    @Override
    public int getRawStatusCode() {
        return this.status.value();
    }

    @Override
    public HttpHeaders getHeaders() {
        String headerName = "Set-Cookie";
        if (!this.getCookies().isEmpty() && this.headers.get(headerName) == null) {
            this.getCookies().values().stream().flatMap(Collection::stream).forEach(cookie -> this.getHeaders().add(headerName, cookie.toString()));
        }
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    public void setBody(Publisher<DataBuffer> body2) {
        this.body = Flux.from(body2);
    }

    public void setBody(String body2) {
        this.setBody(body2, StandardCharsets.UTF_8);
    }

    public void setBody(String body2, Charset charset) {
        DataBuffer buffer = this.toDataBuffer(body2, charset);
        this.body = Flux.just(buffer);
    }

    private DataBuffer toDataBuffer(String body2, Charset charset) {
        byte[] bytes = body2.getBytes(charset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return this.bufferFactory.wrap(byteBuffer);
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public Mono<String> getBodyAsString() {
        Charset charset = this.getCharset();
        return Flux.from(this.getBody()).reduce(this.bufferFactory.allocateBuffer(), (previous, current) -> {
            previous.write((DataBuffer)current);
            DataBufferUtils.release(current);
            return previous;
        }).map(buffer -> MockClientHttpResponse.dumpString(buffer, charset));
    }

    private static String dumpString(DataBuffer buffer, Charset charset) {
        Assert.notNull((Object)charset, "'charset' must not be null");
        byte[] bytes = new byte[buffer.readableByteCount()];
        buffer.read(bytes);
        return new String(bytes, charset);
    }

    private Charset getCharset() {
        Charset charset = null;
        MediaType contentType2 = this.getHeaders().getContentType();
        if (contentType2 != null) {
            charset = contentType2.getCharset();
        }
        return charset != null ? charset : StandardCharsets.UTF_8;
    }
}

