/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client.reactive;

import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockClientHttpRequest
extends AbstractClientHttpRequest {
    private HttpMethod httpMethod;
    private URI url;
    private final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();
    private Flux<DataBuffer> body = Flux.error(new IllegalStateException("The body is not set. Did handling complete with success? Is a custom \"writeHandler\" configured?"));
    private Function<Flux<DataBuffer>, Mono<Void>> writeHandler = this.initDefaultWriteHandler();

    public MockClientHttpRequest(HttpMethod httpMethod, String urlTemplate, Object ... vars) {
        this(httpMethod, UriComponentsBuilder.fromUriString(urlTemplate).buildAndExpand(vars).encode().toUri());
    }

    public MockClientHttpRequest(HttpMethod httpMethod, URI url) {
        this.httpMethod = httpMethod;
        this.url = url;
    }

    private Function<Flux<DataBuffer>, Mono<Void>> initDefaultWriteHandler() {
        return body2 -> {
            this.body = body2.cache();
            return this.body.then();
        };
    }

    @Override
    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    @Override
    public URI getURI() {
        return this.url;
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public void setWriteHandler(Function<Flux<DataBuffer>, Mono<Void>> writeHandler) {
        Assert.notNull(writeHandler, "'writeHandler' is required");
        this.writeHandler = writeHandler;
    }

    @Override
    protected void applyHeaders() {
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).forEach(cookie -> this.getHeaders().add("Cookie", cookie.toString()));
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
        return this.doCommit(() -> Mono.defer(() -> this.writeHandler.apply(Flux.from(body2))));
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
        return this.writeWith(Flux.from(body2).flatMap(p -> p));
    }

    @Override
    public Mono<Void> setComplete() {
        return this.writeWith(Flux.empty());
    }
}

