/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.configuration.CompatibilityPredicate;
import org.springframework.cloud.configuration.CompatibilityVerifier;
import org.springframework.cloud.configuration.VerificationResult;
import org.springframework.util.StringUtils;

class SpringBootVersionVerifier
implements CompatibilityVerifier {
    private static final Log log = LogFactory.getLog(SpringBootVersionVerifier.class);
    final Map<String, CompatibilityPredicate> ACCEPTED_VERSIONS = new HashMap<String, CompatibilityPredicate>(){
        {
            this.put("1.5", SpringBootVersionVerifier.this.is1_5());
            this.put("2.0", SpringBootVersionVerifier.this.is2_0());
            this.put("2.1", SpringBootVersionVerifier.this.is2_1());
        }
    };
    private final List<String> acceptedVersions;

    SpringBootVersionVerifier(List<String> acceptedVersions) {
        this.acceptedVersions = acceptedVersions;
    }

    @Override
    public VerificationResult verify() {
        boolean matches = this.springBootVersionMatches();
        if (matches) {
            return VerificationResult.compatible();
        }
        return VerificationResult.notCompatible(this.errorDescription(), this.action());
    }

    CompatibilityPredicate is1_5() {
        return new CompatibilityPredicate(){

            public String toString() {
                return "Predicate for Boot 1.5";
            }

            @Override
            public boolean isCompatible() {
                try {
                    Class.forName("org.springframework.boot.context.config.ResourceNotFoundException");
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
        };
    }

    private boolean bootVersionFromManifest(String s2) {
        String version = this.getVersionFromManifest();
        if (log.isDebugEnabled()) {
            log.debug("Version found in Boot manifest [" + version + "]");
        }
        return StringUtils.hasText(version) && version.startsWith(s2);
    }

    String getVersionFromManifest() {
        return SpringBootVersion.getVersion();
    }

    CompatibilityPredicate is2_0() {
        return new CompatibilityPredicate(){

            public String toString() {
                return "Predicate for Boot 2.0";
            }

            @Override
            public boolean isCompatible() {
                try {
                    SpringApplicationBuilder.class.getMethod("web", Boolean.TYPE);
                    return !SpringBootVersionVerifier.this.is1_5().isCompatible();
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
            }
        };
    }

    CompatibilityPredicate is2_1() {
        return new CompatibilityPredicate(){

            public String toString() {
                return "Predicate for Boot 2.1";
            }

            @Override
            public boolean isCompatible() {
                try {
                    Class.forName("org.springframework.boot.task.TaskExecutorCustomizer");
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
        };
    }

    private String errorDescription() {
        String versionFromManifest = this.getVersionFromManifest();
        if (StringUtils.hasText(versionFromManifest)) {
            return String.format("Spring Boot [%s] is not compatible with this Spring Cloud release train", versionFromManifest);
        }
        return "Spring Boot is not compatible with this Spring Cloud release train";
    }

    private String action() {
        return String.format("Change Spring Boot version to one of the following versions %s .\nYou can find the latest Spring Boot versions here [%s]. \nIf you want to learn more about the Spring Cloud Release train compatibility, you can visit this page [%s] and check the [Release Trains] section.\nIf you want to disable this check, just set the property [spring.cloud.compatibility-verifier.enabled=false]", this.acceptedVersions, "https://spring.io/projects/spring-boot#learn", "https://spring.io/projects/spring-cloud#overview");
    }

    private boolean springBootVersionMatches() {
        for (String acceptedVersion : this.acceptedVersions) {
            if (this.bootVersionFromManifest(acceptedVersion)) {
                return true;
            }
            CompatibilityPredicate predicate = this.ACCEPTED_VERSIONS.get(this.acceptedVersionWithoutX(acceptedVersion));
            if (predicate == null || !predicate.isCompatible()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Predicate [" + predicate + "] was matched");
            }
            return true;
        }
        return false;
    }

    private String acceptedVersionWithoutX(String acceptedVersion) {
        if (acceptedVersion.endsWith(".x")) {
            return acceptedVersion.substring(0, acceptedVersion.indexOf(".x"));
        }
        return acceptedVersion;
    }
}

