/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.client.ConfigClientHealthProperties;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigClientWatch;
import org.springframework.cloud.config.client.ConfigServerHealthIndicator;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ConfigClientAutoConfiguration {
    @Bean
    public ConfigClientProperties configClientProperties(Environment environment2, ApplicationContext context) {
        if (context.getParent() != null && BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getParent(), ConfigClientProperties.class).length > 0) {
            return BeanFactoryUtils.beanOfTypeIncludingAncestors(context.getParent(), ConfigClientProperties.class);
        }
        ConfigClientProperties client = new ConfigClientProperties(environment2);
        return client;
    }

    @Bean
    public ConfigClientHealthProperties configClientHealthProperties() {
        return new ConfigClientHealthProperties();
    }

    @Configuration
    @ConditionalOnClass(value={ContextRefresher.class})
    @ConditionalOnBean(value={ContextRefresher.class})
    @ConditionalOnProperty(value={"spring.cloud.config.watch.enabled"})
    protected static class ConfigClientWatchConfiguration {
        protected ConfigClientWatchConfiguration() {
        }

        @Bean
        public ConfigClientWatch configClientWatch(ContextRefresher contextRefresher) {
            return new ConfigClientWatch(contextRefresher);
        }
    }

    @Configuration
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnBean(value={ConfigServicePropertySourceLocator.class})
    @ConditionalOnProperty(value={"health.config.enabled"}, matchIfMissing=true)
    protected static class ConfigServerHealthIndicatorConfiguration {
        protected ConfigServerHealthIndicatorConfiguration() {
        }

        @Bean
        public ConfigServerHealthIndicator configServerHealthIndicator(ConfigServicePropertySourceLocator locator, ConfigClientHealthProperties properties, Environment environment2) {
            return new ConfigServerHealthIndicator(locator, environment2, properties);
        }
    }
}

