/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.undertow;

import io.undertow.Undertow;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.SslStoreProvider;
import org.springframework.util.ResourceUtils;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;

class SslBuilderCustomizer
implements UndertowBuilderCustomizer {
    private final int port;
    private final InetAddress address;
    private final Ssl ssl;
    private final SslStoreProvider sslStoreProvider;

    SslBuilderCustomizer(int port, InetAddress address, Ssl ssl, SslStoreProvider sslStoreProvider) {
        this.port = port;
        this.address = address;
        this.ssl = ssl;
        this.sslStoreProvider = sslStoreProvider;
    }

    @Override
    public void customize(Undertow.Builder builder) {
        try {
            SSLContext sslContext = SSLContext.getInstance(this.ssl.getProtocol());
            sslContext.init(this.getKeyManagers(this.ssl, this.sslStoreProvider), this.getTrustManagers(this.ssl, this.sslStoreProvider), null);
            builder.addHttpsListener(this.port, this.getListenAddress(), sslContext);
            builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)this.getSslClientAuthMode(this.ssl));
            if (this.ssl.getEnabledProtocols() != null) {
                builder.setSocketOption(Options.SSL_ENABLED_PROTOCOLS, (Object)Sequence.of((Object[])this.ssl.getEnabledProtocols()));
            }
            if (this.ssl.getCiphers() != null) {
                builder.setSocketOption(Options.SSL_ENABLED_CIPHER_SUITES, (Object)Sequence.of((Object[])this.ssl.getCiphers()));
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        catch (KeyManagementException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String getListenAddress() {
        if (this.address == null) {
            return "0.0.0.0";
        }
        return this.address.getHostAddress();
    }

    private SslClientAuthMode getSslClientAuthMode(Ssl ssl) {
        if (ssl.getClientAuth() == Ssl.ClientAuth.NEED) {
            return SslClientAuthMode.REQUIRED;
        }
        if (ssl.getClientAuth() == Ssl.ClientAuth.WANT) {
            return SslClientAuthMode.REQUESTED;
        }
        return SslClientAuthMode.NOT_REQUESTED;
    }

    private KeyManager[] getKeyManagers(Ssl ssl, SslStoreProvider sslStoreProvider) {
        try {
            char[] keyPassword;
            KeyStore keyStore = this.getKeyStore(ssl, sslStoreProvider);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            char[] cArray = keyPassword = ssl.getKeyPassword() != null ? ssl.getKeyPassword().toCharArray() : null;
            if (keyPassword == null && ssl.getKeyStorePassword() != null) {
                keyPassword = ssl.getKeyStorePassword().toCharArray();
            }
            keyManagerFactory.init(keyStore, keyPassword);
            if (ssl.getKeyAlias() != null) {
                return this.getConfigurableAliasKeyManagers(ssl, keyManagerFactory.getKeyManagers());
            }
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private KeyManager[] getConfigurableAliasKeyManagers(Ssl ssl, KeyManager[] keyManagers) {
        for (int i = 0; i < keyManagers.length; ++i) {
            if (!(keyManagers[i] instanceof X509ExtendedKeyManager)) continue;
            keyManagers[i] = new ConfigurableAliasKeyManager((X509ExtendedKeyManager)keyManagers[i], ssl.getKeyAlias());
        }
        return keyManagers;
    }

    private KeyStore getKeyStore(Ssl ssl, SslStoreProvider sslStoreProvider) throws Exception {
        if (sslStoreProvider != null) {
            return sslStoreProvider.getKeyStore();
        }
        return this.loadKeyStore(ssl.getKeyStoreType(), ssl.getKeyStore(), ssl.getKeyStorePassword());
    }

    private TrustManager[] getTrustManagers(Ssl ssl, SslStoreProvider sslStoreProvider) {
        try {
            KeyStore store = this.getTrustStore(ssl, sslStoreProvider);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(store);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private KeyStore getTrustStore(Ssl ssl, SslStoreProvider sslStoreProvider) throws Exception {
        if (sslStoreProvider != null) {
            return sslStoreProvider.getTrustStore();
        }
        return this.loadKeyStore(ssl.getTrustStoreType(), ssl.getTrustStore(), ssl.getTrustStorePassword());
    }

    private KeyStore loadKeyStore(String type, String resource, String password) throws Exception {
        String string = type = type != null ? type : "JKS";
        if (resource == null) {
            return null;
        }
        KeyStore store = KeyStore.getInstance(type);
        URL url = ResourceUtils.getURL(resource);
        store.load(url.openStream(), password != null ? password.toCharArray() : null);
        return store;
    }

    private static class ConfigurableAliasKeyManager
    extends X509ExtendedKeyManager {
        private final X509ExtendedKeyManager keyManager;
        private final String alias;

        ConfigurableAliasKeyManager(X509ExtendedKeyManager keyManager, String alias) {
            this.keyManager = keyManager;
            this.alias = alias;
        }

        @Override
        public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
            return this.keyManager.chooseEngineClientAlias(strings, principals, sslEngine);
        }

        @Override
        public String chooseEngineServerAlias(String s2, Principal[] principals, SSLEngine sslEngine) {
            if (this.alias == null) {
                return this.keyManager.chooseEngineServerAlias(s2, principals, sslEngine);
            }
            return this.alias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.keyManager.chooseClientAlias(keyType, issuers, socket);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.keyManager.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }
    }
}

