/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.boot.logging.AbstractLoggingSystem;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class Slf4JLoggingSystem
extends AbstractLoggingSystem {
    private static final String BRIDGE_HANDLER = "org.slf4j.bridge.SLF4JBridgeHandler";

    public Slf4JLoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public void beforeInitialize() {
        super.beforeInitialize();
        this.configureJdkLoggingBridgeHandler();
    }

    @Override
    public void cleanUp() {
        this.removeJdkLoggingBridgeHandler();
    }

    @Override
    protected void loadConfiguration(LoggingInitializationContext initializationContext, String location, LogFile logFile) {
        Assert.notNull((Object)location, "Location must not be null");
        if (initializationContext != null) {
            this.applySystemProperties(initializationContext.getEnvironment(), logFile);
        }
    }

    private void configureJdkLoggingBridgeHandler() {
        try {
            if (this.isBridgeHandlerAvailable()) {
                this.removeJdkLoggingBridgeHandler();
                SLF4JBridgeHandler.install();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected final boolean isBridgeHandlerAvailable() {
        return ClassUtils.isPresent(BRIDGE_HANDLER, this.getClassLoader());
    }

    private void removeJdkLoggingBridgeHandler() {
        try {
            if (this.isBridgeHandlerAvailable()) {
                this.removeDefaultRootHandler();
                SLF4JBridgeHandler.uninstall();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void removeDefaultRootHandler() {
        try {
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            Handler[] handlers = rootLogger.getHandlers();
            if (handlers.length == 1 && handlers[0] instanceof ConsoleHandler) {
                rootLogger.removeHandler(handlers[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

