/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.util.Properties;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LogFile {
    public static final String FILE_PROPERTY = "logging.file";
    public static final String PATH_PROPERTY = "logging.path";
    private final String file;
    private final String path;

    LogFile(String file) {
        this(file, null);
    }

    LogFile(String file, String path2) {
        Assert.isTrue(StringUtils.hasLength(file) || StringUtils.hasLength(path2), "File or Path must not be empty");
        this.file = file;
        this.path = path2;
    }

    public void applyToSystemProperties() {
        this.applyTo(System.getProperties());
    }

    public void applyTo(Properties properties) {
        this.put(properties, "LOG_PATH", this.path);
        this.put(properties, "LOG_FILE", this.toString());
    }

    private void put(Properties properties, String key, String value) {
        if (StringUtils.hasLength(value)) {
            properties.put(key, value);
        }
    }

    public String toString() {
        if (StringUtils.hasLength(this.file)) {
            return this.file;
        }
        String path2 = this.path;
        if (!path2.endsWith("/")) {
            path2 = path2 + "/";
        }
        return StringUtils.applyRelativePath(path2, "spring.log");
    }

    public static LogFile get(PropertyResolver propertyResolver) {
        String file = propertyResolver.getProperty(FILE_PROPERTY);
        String path2 = propertyResolver.getProperty(PATH_PROPERTY);
        if (StringUtils.hasLength(file) || StringUtils.hasLength(path2)) {
            return new LogFile(file, path2);
        }
        return null;
    }
}

