/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class InfoProperties
implements Iterable<Entry> {
    private final Properties entries;

    public InfoProperties(Properties entries) {
        Assert.notNull((Object)entries, "Entries must not be null");
        this.entries = this.copy(entries);
    }

    public String get(String key) {
        return this.entries.getProperty(key);
    }

    public Instant getInstant(String key) {
        String s2 = this.get(key);
        if (s2 != null) {
            try {
                return Instant.ofEpochMilli(Long.parseLong(s2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Iterator<Entry> iterator() {
        return new PropertiesIterator(this.entries);
    }

    public PropertySource<?> toPropertySource() {
        return new PropertiesPropertySource(this.getClass().getSimpleName(), this.copy(this.entries));
    }

    private Properties copy(Properties properties) {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)properties);
        return copy;
    }

    public final class Entry {
        private final String key;
        private final String value;

        private Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    private final class PropertiesIterator
    implements Iterator<Entry> {
        private final Iterator<Map.Entry<Object, Object>> iterator;

        private PropertiesIterator(Properties properties) {
            this.iterator = properties.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Entry next() {
            Map.Entry<Object, Object> entry = this.iterator.next();
            return new Entry((String)entry.getKey(), (String)entry.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("InfoProperties are immutable.");
        }
    }
}

