/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.CompositePropertySources;
import org.springframework.boot.context.properties.FilteredPropertySources;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;

class PropertySourcesDeducer {
    private static final Log logger = LogFactory.getLog(PropertySourcesDeducer.class);
    private final ApplicationContext applicationContext;

    PropertySourcesDeducer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public PropertySources getPropertySources() {
        MutablePropertySources environmentPropertySources = this.extractEnvironmentPropertySources();
        PropertySourcesPlaceholderConfigurer placeholderConfigurer = this.getSinglePropertySourcesPlaceholderConfigurer();
        if (placeholderConfigurer == null) {
            Assert.state(environmentPropertySources != null, "Unable to obtain PropertySources from PropertySourcesPlaceholderConfigurer or Environment");
            return environmentPropertySources;
        }
        PropertySources appliedPropertySources = placeholderConfigurer.getAppliedPropertySources();
        if (environmentPropertySources == null) {
            return appliedPropertySources;
        }
        return this.merge(environmentPropertySources, appliedPropertySources);
    }

    private MutablePropertySources extractEnvironmentPropertySources() {
        Environment environment2 = this.applicationContext.getEnvironment();
        if (environment2 instanceof ConfigurableEnvironment) {
            return ((ConfigurableEnvironment)environment2).getPropertySources();
        }
        return null;
    }

    private PropertySourcesPlaceholderConfigurer getSinglePropertySourcesPlaceholderConfigurer() {
        Map<String, PropertySourcesPlaceholderConfigurer> beans2 = this.applicationContext.getBeansOfType(PropertySourcesPlaceholderConfigurer.class, false, false);
        if (beans2.size() == 1) {
            return beans2.values().iterator().next();
        }
        if (beans2.size() > 1 && logger.isWarnEnabled()) {
            logger.warn("Multiple PropertySourcesPlaceholderConfigurer beans registered " + beans2.keySet() + ", falling back to Environment");
        }
        return null;
    }

    private PropertySources merge(PropertySources environmentPropertySources, PropertySources appliedPropertySources) {
        FilteredPropertySources filtered = new FilteredPropertySources(appliedPropertySources, "environmentProperties");
        return new CompositePropertySources(filtered, environmentPropertySources);
    }
}

