/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.http.codec.CodecsAutoConfiguration;
import org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration;
import org.springframework.boot.autoconfigure.validation.ValidatorAdapter;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.format.WebConversionService;
import org.springframework.boot.autoconfigure.web.reactive.ReactiveWebServerFactoryAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.CacheControl;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Validator;
import org.springframework.web.reactive.config.DelegatingWebFluxConfiguration;
import org.springframework.web.reactive.config.ResourceChainRegistration;
import org.springframework.web.reactive.config.ResourceHandlerRegistration;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.ViewResolverRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurationSupport;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.resource.AppCacheManifestTransformer;
import org.springframework.web.reactive.resource.GzipResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.VersionResourceResolver;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.view.ViewResolver;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={WebFluxConfigurer.class})
@ConditionalOnMissingBean(value={WebFluxConfigurationSupport.class})
@AutoConfigureAfter(value={ReactiveWebServerFactoryAutoConfiguration.class, CodecsAutoConfiguration.class, ValidationAutoConfiguration.class})
@AutoConfigureOrder(value=-2147483638)
public class WebFluxAutoConfiguration {

    private static class ResourceChainResourceHandlerRegistrationCustomizer
    implements ResourceHandlerRegistrationCustomizer {
        @Autowired
        private ResourceProperties resourceProperties = new ResourceProperties();

        private ResourceChainResourceHandlerRegistrationCustomizer() {
        }

        @Override
        public void customize(ResourceHandlerRegistration registration) {
            ResourceProperties.Chain properties = this.resourceProperties.getChain();
            this.configureResourceChain(properties, registration.resourceChain(properties.isCache()));
        }

        private void configureResourceChain(ResourceProperties.Chain properties, ResourceChainRegistration chain) {
            ResourceProperties.Strategy strategy = properties.getStrategy();
            if (strategy.getFixed().isEnabled() || strategy.getContent().isEnabled()) {
                chain.addResolver(this.getVersionResourceResolver(strategy));
            }
            if (properties.isGzipped()) {
                chain.addResolver(new GzipResourceResolver());
            }
            if (properties.isHtmlApplicationCache()) {
                chain.addTransformer(new AppCacheManifestTransformer());
            }
        }

        private ResourceResolver getVersionResourceResolver(ResourceProperties.Strategy properties) {
            VersionResourceResolver resolver = new VersionResourceResolver();
            if (properties.getFixed().isEnabled()) {
                String version = properties.getFixed().getVersion();
                String[] paths = properties.getFixed().getPaths();
                resolver.addFixedVersionStrategy(version, paths);
            }
            if (properties.getContent().isEnabled()) {
                String[] paths = properties.getContent().getPaths();
                resolver.addContentVersionStrategy(paths);
            }
            return resolver;
        }
    }

    static interface ResourceHandlerRegistrationCustomizer {
        public void customize(ResourceHandlerRegistration var1);
    }

    @Configuration
    @ConditionalOnEnabledResourceChain
    static class ResourceChainCustomizerConfiguration {
        ResourceChainCustomizerConfiguration() {
        }

        @Bean
        public ResourceChainResourceHandlerRegistrationCustomizer resourceHandlerRegistrationCustomizer() {
            return new ResourceChainResourceHandlerRegistrationCustomizer();
        }
    }

    @Configuration
    public static class EnableWebFluxConfiguration
    extends DelegatingWebFluxConfiguration {
        private final WebFluxProperties webFluxProperties;

        public EnableWebFluxConfiguration(WebFluxProperties webFluxProperties) {
            this.webFluxProperties = webFluxProperties;
        }

        @Override
        @Bean
        public FormattingConversionService webFluxConversionService() {
            WebConversionService conversionService = new WebConversionService(this.webFluxProperties.getDateFormat());
            this.addFormatters(conversionService);
            return conversionService;
        }

        @Override
        @Bean
        public Validator webFluxValidator() {
            if (!ClassUtils.isPresent("javax.validation.Validator", this.getClass().getClassLoader())) {
                return super.webFluxValidator();
            }
            return ValidatorAdapter.get(this.getApplicationContext(), this.getValidator());
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={ResourceProperties.class, WebFluxProperties.class})
    @Import(value={EnableWebFluxConfiguration.class})
    public static class WebFluxConfig
    implements WebFluxConfigurer {
        private static final Log logger = LogFactory.getLog(WebFluxConfig.class);
        private final ResourceProperties resourceProperties;
        private final WebFluxProperties webFluxProperties;
        private final ListableBeanFactory beanFactory;
        private final List<HandlerMethodArgumentResolver> argumentResolvers;
        private final List<CodecCustomizer> codecCustomizers;
        private final ResourceHandlerRegistrationCustomizer resourceHandlerRegistrationCustomizer;
        private final List<ViewResolver> viewResolvers;

        public WebFluxConfig(ResourceProperties resourceProperties, WebFluxProperties webFluxProperties, ListableBeanFactory beanFactory, ObjectProvider<List<HandlerMethodArgumentResolver>> resolvers, ObjectProvider<List<CodecCustomizer>> codecCustomizers, ObjectProvider<ResourceHandlerRegistrationCustomizer> resourceHandlerRegistrationCustomizer, ObjectProvider<List<ViewResolver>> viewResolvers) {
            this.resourceProperties = resourceProperties;
            this.webFluxProperties = webFluxProperties;
            this.beanFactory = beanFactory;
            this.argumentResolvers = resolvers.getIfAvailable();
            this.codecCustomizers = codecCustomizers.getIfAvailable();
            this.resourceHandlerRegistrationCustomizer = resourceHandlerRegistrationCustomizer.getIfAvailable();
            this.viewResolvers = viewResolvers.getIfAvailable();
        }

        @Override
        public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
            if (this.argumentResolvers != null) {
                this.argumentResolvers.forEach(xva$0 -> configurer.addCustomResolver((HandlerMethodArgumentResolver)xva$0));
            }
        }

        @Override
        public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
            if (this.codecCustomizers != null) {
                this.codecCustomizers.forEach(customizer2 -> customizer2.customize(configurer));
            }
        }

        @Override
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            String staticPathPattern;
            if (!this.resourceProperties.isAddMappings()) {
                logger.debug("Default resource handling disabled");
                return;
            }
            Duration cachePeriod = this.resourceProperties.getCache().getPeriod();
            if (!registry.hasMappingForPattern("/webjars/**")) {
                ResourceHandlerRegistration registration = registry.addResourceHandler("/webjars/**").addResourceLocations("classpath:/META-INF/resources/webjars/");
                if (cachePeriod != null) {
                    registration.setCacheControl(CacheControl.maxAge(cachePeriod.toMillis(), TimeUnit.MILLISECONDS));
                }
                this.customizeResourceHandlerRegistration(registration);
            }
            if (!registry.hasMappingForPattern(staticPathPattern = this.webFluxProperties.getStaticPathPattern())) {
                ResourceHandlerRegistration registration = registry.addResourceHandler(staticPathPattern).addResourceLocations(this.resourceProperties.getStaticLocations());
                if (cachePeriod != null) {
                    registration.setCacheControl(CacheControl.maxAge(cachePeriod.toMillis(), TimeUnit.MILLISECONDS));
                }
                this.customizeResourceHandlerRegistration(registration);
            }
        }

        @Override
        public void configureViewResolvers(ViewResolverRegistry registry) {
            if (this.viewResolvers != null) {
                AnnotationAwareOrderComparator.sort(this.viewResolvers);
                this.viewResolvers.forEach(registry::viewResolver);
            }
        }

        @Override
        public void addFormatters(FormatterRegistry registry) {
            for (Converter converter : this.getBeansOfType(Converter.class)) {
                registry.addConverter(converter);
            }
            for (GenericConverter genericConverter : this.getBeansOfType(GenericConverter.class)) {
                registry.addConverter(genericConverter);
            }
            for (Formatter formatter : this.getBeansOfType(Formatter.class)) {
                registry.addFormatter(formatter);
            }
        }

        private <T> Collection<T> getBeansOfType(Class<T> type) {
            return this.beanFactory.getBeansOfType(type).values();
        }

        private void customizeResourceHandlerRegistration(ResourceHandlerRegistration registration) {
            if (this.resourceHandlerRegistrationCustomizer != null) {
                this.resourceHandlerRegistrationCustomizer.customize(registration);
            }
        }
    }
}

