/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationInitializer;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.flyway.FlywaySchemaManagementProvider;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Flyway.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="spring.flyway", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class FlywayAutoConfiguration {
    @Bean
    @ConfigurationPropertiesBinding
    public StringOrNumberToMigrationVersionConverter stringOrNumberMigrationVersionConverter() {
        return new StringOrNumberToMigrationVersionConverter();
    }

    @Bean
    public FlywaySchemaManagementProvider flywayDefaultDdlModeProvider(ObjectProvider<List<Flyway>> flyways) {
        return new FlywaySchemaManagementProvider(flyways.getIfAvailable(Collections::emptyList));
    }

    private static class StringOrNumberToMigrationVersionConverter
    implements GenericConverter {
        private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES;

        private StringOrNumberToMigrationVersionConverter() {
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return CONVERTIBLE_TYPES;
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            String value = ObjectUtils.nullSafeToString(source);
            return MigrationVersion.fromVersion((String)value);
        }

        static {
            HashSet<GenericConverter.ConvertiblePair> types = new HashSet<GenericConverter.ConvertiblePair>(2);
            types.add(new GenericConverter.ConvertiblePair(String.class, MigrationVersion.class));
            types.add(new GenericConverter.ConvertiblePair(Number.class, MigrationVersion.class));
            CONVERTIBLE_TYPES = Collections.unmodifiableSet(types);
        }
    }

    private static class LocationResolver {
        private static final String VENDOR_PLACEHOLDER = "{vendor}";
        private final DataSource dataSource;

        LocationResolver(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public String[] resolveLocations(Collection<String> locations) {
            return this.resolveLocations(StringUtils.toStringArray(locations));
        }

        public String[] resolveLocations(String[] locations) {
            if (this.usesVendorLocation(locations)) {
                DatabaseDriver databaseDriver = this.getDatabaseDriver();
                return this.replaceVendorLocations(locations, databaseDriver);
            }
            return locations;
        }

        private String[] replaceVendorLocations(String[] locations, DatabaseDriver databaseDriver) {
            if (databaseDriver == DatabaseDriver.UNKNOWN) {
                return locations;
            }
            String vendor = databaseDriver.getId();
            return (String[])Arrays.stream(locations).map(location -> location.replace(VENDOR_PLACEHOLDER, vendor)).toArray(String[]::new);
        }

        private DatabaseDriver getDatabaseDriver() {
            try {
                String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getURL");
                return DatabaseDriver.fromJdbcUrl(url);
            }
            catch (MetaDataAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private boolean usesVendorLocation(String ... locations) {
            for (String location : locations) {
                if (!location.contains(VENDOR_PLACEHOLDER)) continue;
                return true;
            }
            return false;
        }
    }

    private static class SpringBootFlyway
    extends Flyway {
        private SpringBootFlyway() {
        }

        public void setLocations(String ... locations) {
            super.setLocations(new LocationResolver(this.getDataSource()).resolveLocations(locations));
        }
    }

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    protected static class FlywayJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        public FlywayJpaDependencyConfiguration() {
            super("flyway");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={Flyway.class})
    @EnableConfigurationProperties(value={DataSourceProperties.class, FlywayProperties.class})
    public static class FlywayConfiguration {
        private final FlywayProperties properties;
        private final DataSourceProperties dataSourceProperties;
        private final ResourceLoader resourceLoader;
        private final DataSource dataSource;
        private final DataSource flywayDataSource;
        private final FlywayMigrationStrategy migrationStrategy;
        private List<FlywayCallback> flywayCallbacks;

        public FlywayConfiguration(FlywayProperties properties, DataSourceProperties dataSourceProperties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, @FlywayDataSource ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayMigrationStrategy> migrationStrategy, ObjectProvider<List<FlywayCallback>> flywayCallbacks) {
            this.properties = properties;
            this.dataSourceProperties = dataSourceProperties;
            this.resourceLoader = resourceLoader;
            this.dataSource = dataSource.getIfUnique();
            this.flywayDataSource = flywayDataSource.getIfAvailable();
            this.migrationStrategy = migrationStrategy.getIfAvailable();
            this.flywayCallbacks = flywayCallbacks.getIfAvailable(Collections::emptyList);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.flyway")
        public Flyway flyway() {
            SpringBootFlyway flyway = new SpringBootFlyway();
            if (this.properties.isCreateDataSource()) {
                String url = this.getProperty(this.properties::getUrl, this.dataSourceProperties::getUrl);
                String user = this.getProperty(this.properties::getUser, this.dataSourceProperties::getUsername);
                String password = this.getProperty(this.properties::getPassword, this.dataSourceProperties::getPassword);
                flyway.setDataSource(url, user, password, StringUtils.toStringArray(this.properties.getInitSqls()));
            } else if (this.flywayDataSource != null) {
                flyway.setDataSource(this.flywayDataSource);
            } else {
                flyway.setDataSource(this.dataSource);
            }
            flyway.setCallbacks(this.flywayCallbacks.toArray(new FlywayCallback[0]));
            String[] locations = new LocationResolver(flyway.getDataSource()).resolveLocations(this.properties.getLocations());
            this.checkLocationExists(locations);
            flyway.setLocations(locations);
            return flyway;
        }

        private String getProperty(Supplier<String> property, Supplier<String> defaultValue) {
            String value = property.get();
            return value != null ? value : defaultValue.get();
        }

        private void checkLocationExists(String ... locations) {
            if (this.properties.isCheckLocation()) {
                Assert.state(locations.length != 0, "Migration script locations not configured");
                boolean exists = this.hasAtLeastOneLocation(locations);
                Assert.state(exists, () -> "Cannot find migrations location in: " + Arrays.asList(locations) + " (please add migrations or check your Flyway configuration)");
            }
        }

        private boolean hasAtLeastOneLocation(String ... locations) {
            for (String location : locations) {
                if (!this.resourceLoader.getResource(location).exists()) continue;
                return true;
            }
            return false;
        }

        @Bean
        @ConditionalOnMissingBean
        public FlywayMigrationInitializer flywayInitializer(Flyway flyway) {
            return new FlywayMigrationInitializer(flyway, this.migrationStrategy);
        }

        @Configuration
        @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
        @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
        protected static class FlywayInitializerJpaDependencyConfiguration
        extends EntityManagerFactoryDependsOnPostProcessor {
            public FlywayInitializerJpaDependencyConfiguration() {
                super("flywayInitializer");
            }
        }
    }
}

