/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.servlet;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTagsProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.util.NestedServletException;

@Order(value=-2147483647)
public class WebMvcMetricsFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcMetricsFilter.class);
    private final ApplicationContext context;
    private final MeterRegistry registry;
    private final WebMvcTagsProvider tagsProvider;
    private final String metricName;
    private final boolean autoTimeRequests;
    private volatile HandlerMappingIntrospector introspector;

    public WebMvcMetricsFilter(ApplicationContext context, MeterRegistry registry, WebMvcTagsProvider tagsProvider, String metricName, boolean autoTimeRequests) {
        this.context = context;
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.metricName = metricName;
        this.autoTimeRequests = autoTimeRequests;
    }

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.filterAndRecordMetrics(request, response, filterChain);
    }

    private void filterAndRecordMetrics(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Object handler;
        try {
            handler = this.getHandler(request);
        }
        catch (Exception ex) {
            logger.debug("Unable to time request", ex);
            filterChain.doFilter(request, response);
            return;
        }
        this.filterAndRecordMetrics(request, response, filterChain, handler);
    }

    private Object getHandler(HttpServletRequest request) throws Exception {
        UnmodifiableAttributesRequestWrapper wrapper = new UnmodifiableAttributesRequestWrapper(request);
        for (HandlerMapping mapping : this.getMappingIntrospector().getHandlerMappings()) {
            HandlerExecutionChain chain = mapping.getHandler(wrapper);
            if (chain == null) continue;
            if (mapping instanceof MatchableHandlerMapping) {
                return chain.getHandler();
            }
            return null;
        }
        return null;
    }

    private HandlerMappingIntrospector getMappingIntrospector() {
        if (this.introspector == null) {
            this.introspector = this.context.getBean(HandlerMappingIntrospector.class);
        }
        return this.introspector;
    }

    private void filterAndRecordMetrics(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, Object handler) throws IOException, ServletException {
        TimingContext timingContext = TimingContext.get(request);
        if (timingContext == null) {
            timingContext = this.startAndAttachTimingContext(request, handler);
        }
        try {
            filterChain.doFilter(request, response);
            if (!request.isAsyncStarted()) {
                Throwable exception = (Throwable)request.getAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE);
                this.record(timingContext, response, request, handler, exception);
            }
        }
        catch (NestedServletException ex) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            this.record(timingContext, response, request, handler, ex.getCause());
            throw ex;
        }
    }

    private TimingContext startAndAttachTimingContext(HttpServletRequest request, Object handler) {
        Set<Timed> annotations = this.getTimedAnnotations(handler);
        Timer.Sample timerSample = Timer.start(this.registry);
        Collection<LongTaskTimer.Sample> longTaskTimerSamples = this.getLongTaskTimerSamples(request, handler, annotations);
        TimingContext timingContext = new TimingContext(annotations, timerSample, longTaskTimerSamples);
        timingContext.attachTo(request);
        return timingContext;
    }

    private Set<Timed> getTimedAnnotations(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return Collections.emptySet();
        }
        return this.getTimedAnnotations((HandlerMethod)handler);
    }

    private Set<Timed> getTimedAnnotations(HandlerMethod handler) {
        Set<Timed> timed = this.findTimedAnnotations(handler.getMethod());
        if (timed.isEmpty()) {
            return this.findTimedAnnotations(handler.getBeanType());
        }
        return timed;
    }

    private Set<Timed> findTimedAnnotations(AnnotatedElement element) {
        return AnnotationUtils.getDeclaredRepeatableAnnotations(element, Timed.class);
    }

    private Collection<LongTaskTimer.Sample> getLongTaskTimerSamples(HttpServletRequest request, Object handler, Set<Timed> annotations) {
        ArrayList<LongTaskTimer.Sample> samples = new ArrayList<LongTaskTimer.Sample>();
        annotations.stream().filter(Timed::longTask).forEach(annotation -> {
            Iterable<Tag> tags = this.tagsProvider.getLongRequestTags(request, handler);
            LongTaskTimer.Builder builder = LongTaskTimer.builder(annotation).tags(tags);
            LongTaskTimer timer = builder.register(this.registry);
            samples.add(timer.start());
        });
        return samples;
    }

    private void record(TimingContext timingContext, HttpServletResponse response, HttpServletRequest request, Object handlerObject, Throwable exception) {
        Timer.Sample timerSample = timingContext.getTimerSample();
        Supplier<Iterable<Tag>> tags = () -> this.tagsProvider.getTags(request, response, handlerObject, exception);
        for (Timed annotation : timingContext.getAnnotations()) {
            this.stop(timerSample, tags, Timer.builder(annotation, this.metricName));
        }
        if (timingContext.getAnnotations().isEmpty() && this.autoTimeRequests) {
            this.stop(timerSample, tags, Timer.builder(this.metricName));
        }
        for (LongTaskTimer.Sample sample : timingContext.getLongTaskTimerSamples()) {
            sample.stop();
        }
    }

    private void stop(Timer.Sample timerSample, Supplier<Iterable<Tag>> tags, Timer.Builder builder) {
        timerSample.stop(builder.tags(tags.get()).register(this.registry));
    }

    private static final class UnmodifiableAttributesRequestWrapper
    extends HttpServletRequestWrapper {
        private UnmodifiableAttributesRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        @Override
        public void setAttribute(String name, Object value) {
        }
    }

    private static class TimingContext {
        private static final String ATTRIBUTE = TimingContext.class.getName();
        private final Set<Timed> annotations;
        private final Timer.Sample timerSample;
        private final Collection<LongTaskTimer.Sample> longTaskTimerSamples;

        TimingContext(Set<Timed> annotations, Timer.Sample timerSample, Collection<LongTaskTimer.Sample> longTaskTimerSamples) {
            this.annotations = annotations;
            this.timerSample = timerSample;
            this.longTaskTimerSamples = longTaskTimerSamples;
        }

        public Set<Timed> getAnnotations() {
            return this.annotations;
        }

        public Timer.Sample getTimerSample() {
            return this.timerSample;
        }

        public Collection<LongTaskTimer.Sample> getLongTaskTimerSamples() {
            return this.longTaskTimerSamples;
        }

        public void attachTo(HttpServletRequest request) {
            request.setAttribute(ATTRIBUTE, this);
        }

        public static TimingContext get(HttpServletRequest request) {
            return (TimingContext)request.getAttribute(ATTRIBUTE);
        }
    }
}

