/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.annotation.DiscoveredOperationMethod;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.WebEndpointHttpMethod;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.WebOperationRequestPredicate;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

class RequestPredicateFactory {
    private final EndpointMediaTypes endpointMediaTypes;

    RequestPredicateFactory(EndpointMediaTypes endpointMediaTypes) {
        Assert.notNull((Object)endpointMediaTypes, "EndpointMediaTypes must not be null");
        this.endpointMediaTypes = endpointMediaTypes;
    }

    public WebOperationRequestPredicate getRequestPredicate(String endpointId, String rootPath, DiscoveredOperationMethod operationMethod) {
        Method method2 = operationMethod.getMethod();
        String path2 = this.getPath(rootPath, method2);
        WebEndpointHttpMethod httpMethod = this.determineHttpMethod(operationMethod.getOperationType());
        Collection<String> consumes = this.getConsumes(httpMethod, method2);
        Collection<String> produces = this.getProduces(operationMethod, method2);
        return new WebOperationRequestPredicate(path2, httpMethod, consumes, produces);
    }

    private String getPath(String rootPath, Method method2) {
        return rootPath + Stream.of(method2.getParameters()).filter(this::hasSelector).map(this::slashName).collect(Collectors.joining());
    }

    private boolean hasSelector(Parameter parameter) {
        return parameter.getAnnotation(Selector.class) != null;
    }

    private String slashName(Parameter parameter) {
        return "/{" + parameter.getName() + "}";
    }

    private Collection<String> getConsumes(WebEndpointHttpMethod httpMethod, Method method2) {
        if (WebEndpointHttpMethod.POST == httpMethod && this.consumesRequestBody(method2)) {
            return this.endpointMediaTypes.getConsumed();
        }
        return Collections.emptyList();
    }

    private Collection<String> getProduces(DiscoveredOperationMethod operationMethod, Method method2) {
        if (!operationMethod.getProducesMediaTypes().isEmpty()) {
            return operationMethod.getProducesMediaTypes();
        }
        if (Void.class.equals(method2.getReturnType()) || Void.TYPE.equals(method2.getReturnType())) {
            return Collections.emptyList();
        }
        if (this.producesResource(method2)) {
            return Collections.singletonList("application/octet-stream");
        }
        return this.endpointMediaTypes.getProduced();
    }

    private boolean producesResource(Method method2) {
        if (Resource.class.equals(method2.getReturnType())) {
            return true;
        }
        if (WebEndpointResponse.class.isAssignableFrom(method2.getReturnType())) {
            ResolvableType returnType = ResolvableType.forMethodReturnType(method2);
            if (ResolvableType.forClass(Resource.class).isAssignableFrom(returnType.getGeneric(0))) {
                return true;
            }
        }
        return false;
    }

    private boolean consumesRequestBody(Method method2) {
        return Stream.of(method2.getParameters()).anyMatch(parameter -> parameter.getAnnotation(Selector.class) == null);
    }

    private WebEndpointHttpMethod determineHttpMethod(OperationType operationType) {
        if (operationType == OperationType.WRITE) {
            return WebEndpointHttpMethod.POST;
        }
        if (operationType == OperationType.DELETE) {
            return WebEndpointHttpMethod.DELETE;
        }
        return WebEndpointHttpMethod.GET;
    }
}

