/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.jdbc.HikariDataSourceMetricsPostProcessor;
import org.springframework.boot.actuate.metrics.jdbc.DataSourcePoolMetrics;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, DataSourceAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnBean(value={DataSource.class, DataSourcePoolMetadataProvider.class, MeterRegistry.class})
public class DataSourcePoolMetricsAutoConfiguration {
    private static final String DATASOURCE_SUFFIX = "dataSource";
    private final MeterRegistry registry;
    private final Collection<DataSourcePoolMetadataProvider> metadataProviders;

    public DataSourcePoolMetricsAutoConfiguration(MeterRegistry registry, Collection<DataSourcePoolMetadataProvider> metadataProviders) {
        this.registry = registry;
        this.metadataProviders = metadataProviders;
    }

    @Autowired
    public void bindDataSourcesToRegistry(Map<String, DataSource> dataSources) {
        dataSources.forEach(this::bindDataSourceToRegistry);
    }

    private void bindDataSourceToRegistry(String beanName, DataSource dataSource) {
        String dataSourceName = this.getDataSourceName(beanName);
        new DataSourcePoolMetrics(dataSource, this.metadataProviders, dataSourceName, Collections.emptyList()).bindTo(this.registry);
    }

    private String getDataSourceName(String beanName) {
        if (beanName.length() > DATASOURCE_SUFFIX.length() && StringUtils.endsWithIgnoreCase(beanName, DATASOURCE_SUFFIX)) {
            return beanName.substring(0, beanName.length() - DATASOURCE_SUFFIX.length());
        }
        return beanName;
    }

    @Configuration
    @ConditionalOnClass(value={HikariDataSource.class})
    static class HikariDataSourceMetricsConfiguration {
        HikariDataSourceMetricsConfiguration() {
        }

        @Bean
        public static HikariDataSourceMetricsPostProcessor hikariDataSourceMetricsPostProcessor(ApplicationContext applicationContext) {
            return new HikariDataSourceMetricsPostProcessor(applicationContext);
        }
    }
}

