/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import ch.qos.logback.classic.LoggerContext;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryPostProcessor;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.PropertiesMeterFilter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@ConditionalOnClass(value={Timed.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class})
public class MetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }

    @Bean
    public static MeterRegistryPostProcessor meterRegistryPostProcessor(ApplicationContext context) {
        return new MeterRegistryPostProcessor(context);
    }

    @Bean
    @Order(value=0)
    public PropertiesMeterFilter propertiesMeterFilter(MetricsProperties properties) {
        return new PropertiesMeterFilter(properties);
    }

    static class LogbackLoggingCondition
    extends SpringBootCondition {
        LogbackLoggingCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            ConditionMessage.Builder message = ConditionMessage.forCondition("LogbackLoggingCondition", new Object[0]);
            if (loggerFactory instanceof LoggerContext) {
                return ConditionOutcome.match(message.because("ILoggerFactory is a Logback LoggerContext"));
            }
            return ConditionOutcome.noMatch(message.because("ILoggerFactory is an instance of " + loggerFactory.getClass().getCanonicalName()));
        }
    }

    @Configuration
    static class MeterBindersConfiguration {
        MeterBindersConfiguration() {
        }

        @Bean
        @ConditionalOnClass(name={"ch.qos.logback.classic.LoggerContext", "org.slf4j.LoggerFactory"})
        @Conditional(value={LogbackLoggingCondition.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"management.metrics.binders.logback.enabled"}, matchIfMissing=true)
        public LogbackMetrics logbackMetrics() {
            return new LogbackMetrics();
        }

        @Bean
        @ConditionalOnProperty(value={"management.metrics.binders.uptime.enabled"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public UptimeMetrics uptimeMetrics() {
            return new UptimeMetrics();
        }

        @Bean
        @ConditionalOnProperty(value={"management.metrics.binders.processor.enabled"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public ProcessorMetrics processorMetrics() {
            return new ProcessorMetrics();
        }

        @Bean
        @ConditionalOnProperty(name={"management.metrics.binders.files.enabled"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public FileDescriptorMetrics fileDescriptorMetrics() {
            return new FileDescriptorMetrics();
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"management.metrics.binders.jvm.enabled"}, matchIfMissing=true)
    static class JvmMeterBindersConfiguration {
        JvmMeterBindersConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public JvmGcMetrics jvmGcMetrics() {
            return new JvmGcMetrics();
        }

        @Bean
        @ConditionalOnMissingBean
        public JvmMemoryMetrics jvmMemoryMetrics() {
            return new JvmMemoryMetrics();
        }

        @Bean
        @ConditionalOnMissingBean
        public JvmThreadMetrics jvmThreadMetrics() {
            return new JvmThreadMetrics();
        }

        @Bean
        @ConditionalOnMissingBean
        public ClassLoaderMetrics classLoaderMetrics() {
            return new ClassLoaderMetrics();
        }
    }
}

