/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.AccessLevel;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.CloudFoundryAuthorizationException;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.SecurityResponse;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.Token;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundrySecurityService;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.TokenValidator;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsUtils;

class CloudFoundrySecurityInterceptor {
    private static final Log logger = LogFactory.getLog(CloudFoundrySecurityInterceptor.class);
    private final TokenValidator tokenValidator;
    private final CloudFoundrySecurityService cloudFoundrySecurityService;
    private final String applicationId;
    private static final SecurityResponse SUCCESS = SecurityResponse.success();

    CloudFoundrySecurityInterceptor(TokenValidator tokenValidator, CloudFoundrySecurityService cloudFoundrySecurityService, String applicationId) {
        this.tokenValidator = tokenValidator;
        this.cloudFoundrySecurityService = cloudFoundrySecurityService;
        this.applicationId = applicationId;
    }

    SecurityResponse preHandle(HttpServletRequest request, String endpointId) {
        if (CorsUtils.isPreFlightRequest(request)) {
            return SecurityResponse.success();
        }
        try {
            if (!StringUtils.hasText(this.applicationId)) {
                throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, "Application id is not available");
            }
            if (this.cloudFoundrySecurityService == null) {
                throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, "Cloud controller URL is not available");
            }
            if (HttpMethod.OPTIONS.matches(request.getMethod())) {
                return SUCCESS;
            }
            this.check(request, endpointId);
        }
        catch (Exception ex) {
            logger.error(ex);
            if (ex instanceof CloudFoundryAuthorizationException) {
                CloudFoundryAuthorizationException cfException = (CloudFoundryAuthorizationException)ex;
                return new SecurityResponse(cfException.getStatusCode(), "{\"security_error\":\"" + cfException.getMessage() + "\"}");
            }
            return new SecurityResponse(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
        return SecurityResponse.success();
    }

    private void check(HttpServletRequest request, String endpointId) throws Exception {
        Token token = this.getToken(request);
        this.tokenValidator.validate(token);
        AccessLevel accessLevel = this.cloudFoundrySecurityService.getAccessLevel(token.toString(), this.applicationId);
        if (!accessLevel.isAccessAllowed(endpointId)) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.ACCESS_DENIED, "Access denied");
        }
        request.setAttribute("cloudFoundryAccessLevel", (Object)accessLevel);
    }

    private Token getToken(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        String bearerPrefix = "bearer ";
        if (authorization == null || !authorization.toLowerCase(Locale.ENGLISH).startsWith(bearerPrefix)) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.MISSING_AUTHORIZATION, "Authorization header is missing or invalid");
        }
        return new Token(authorization.substring(bearerPrefix.length()));
    }
}

