/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.TokenList;

public class ResponseUtil {
    private static final String VARY_HEADER = "vary";
    private static final String VARY_ALL = "*";

    private ResponseUtil() {
    }

    public static void addVaryFieldName(MimeHeaders headers2, String name) {
        ResponseUtil.addVaryFieldName(new HeaderAdapter(headers2), name);
    }

    public static void addVaryFieldName(HttpServletResponse response, String name) {
        ResponseUtil.addVaryFieldName(new ResponseAdapter(response), name);
    }

    private static void addVaryFieldName(Adapter adapter, String name) {
        Collection<String> varyHeaders = adapter.getHeaders(VARY_HEADER);
        if (varyHeaders.size() == 1 && varyHeaders.iterator().next().trim().equals(VARY_ALL)) {
            return;
        }
        if (varyHeaders.size() == 0) {
            adapter.addHeader(VARY_HEADER, name);
            return;
        }
        if (VARY_ALL.equals(name.trim())) {
            adapter.setHeader(VARY_HEADER, VARY_ALL);
            return;
        }
        HashSet<String> fieldNames = new HashSet<String>();
        for (String varyHeader : varyHeaders) {
            StringReader input = new StringReader(varyHeader);
            try {
                TokenList.parseTokenList(input, fieldNames);
            }
            catch (IOException iOException) {}
        }
        if (fieldNames.contains(VARY_ALL)) {
            adapter.setHeader(VARY_HEADER, VARY_ALL);
            return;
        }
        fieldNames.add(name);
        StringBuilder varyHeader = new StringBuilder();
        varyHeader.append(name);
        for (String fieldName : fieldNames) {
            varyHeader.append(',');
            varyHeader.append(fieldName);
        }
        adapter.setHeader(VARY_HEADER, varyHeader.toString());
    }

    private static final class ResponseAdapter
    implements Adapter {
        private final HttpServletResponse response;

        public ResponseAdapter(HttpServletResponse response) {
            this.response = response;
        }

        @Override
        public Collection<String> getHeaders(String name) {
            return this.response.getHeaders(name);
        }

        @Override
        public void setHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        @Override
        public void addHeader(String name, String value) {
            this.response.addHeader(name, value);
        }
    }

    private static final class HeaderAdapter
    implements Adapter {
        private final MimeHeaders headers;

        public HeaderAdapter(MimeHeaders headers2) {
            this.headers = headers2;
        }

        @Override
        public Collection<String> getHeaders(String name) {
            Enumeration<String> values = this.headers.values(name);
            ArrayList<String> result = new ArrayList<String>();
            while (values.hasMoreElements()) {
                result.add(values.nextElement());
            }
            return result;
        }

        @Override
        public void setHeader(String name, String value) {
            this.headers.setValue(name).setString(value);
        }

        @Override
        public void addHeader(String name, String value) {
            this.headers.addValue(name).setString(value);
        }
    }

    private static interface Adapter {
        public Collection<String> getHeaders(String var1);

        public void setHeader(String var1, String var2);

        public void addHeader(String var1, String var2);
    }
}

