/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractFileResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class DirResourceSet
extends AbstractFileResourceSet {
    private static final Log log = LogFactory.getLog(DirResourceSet.class);

    public DirResourceSet() {
        super("/");
    }

    public DirResourceSet(WebResourceRoot root, String webAppMount, String base, String internalPath) {
        super(internalPath);
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        if (root.getContext().getAddWebinfClassesResources()) {
            File f = new File(base, internalPath);
            if ((f = new File(f, "/WEB-INF/classes/META-INF/resources")).isDirectory()) {
                root.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", f.getAbsolutePath(), null, "/");
            }
        }
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public WebResource getResource(String path2) {
        this.checkPath(path2);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot root = this.getRoot();
        if (path2.startsWith(webAppMount)) {
            File f = this.file(path2.substring(webAppMount.length()), false);
            if (f == null) {
                return new EmptyResource(root, path2);
            }
            if (!f.exists()) {
                return new EmptyResource(root, path2, f);
            }
            if (f.isDirectory() && path2.charAt(path2.length() - 1) != '/') {
                path2 = path2 + '/';
            }
            return new FileResource(root, path2, f, this.isReadOnly(), this.getManifest());
        }
        return new EmptyResource(root, path2);
    }

    @Override
    public String[] list(String path2) {
        this.checkPath(path2);
        String webAppMount = this.getWebAppMount();
        if (path2.startsWith(webAppMount)) {
            File f = this.file(path2.substring(webAppMount.length()), true);
            if (f == null) {
                return EMPTY_STRING_ARRAY;
            }
            String[] result = f.list();
            if (result == null) {
                return EMPTY_STRING_ARRAY;
            }
            return result;
        }
        if (!path2.endsWith("/")) {
            path2 = path2 + "/";
        }
        if (webAppMount.startsWith(path2)) {
            int i = webAppMount.indexOf(47, path2.length());
            if (i == -1) {
                return new String[]{webAppMount.substring(path2.length())};
            }
            return new String[]{webAppMount.substring(path2.length(), i)};
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> listWebAppPaths(String path2) {
        this.checkPath(path2);
        String webAppMount = this.getWebAppMount();
        ResourceSet<String> result = new ResourceSet<String>();
        if (path2.startsWith(webAppMount)) {
            File[] list;
            File f = this.file(path2.substring(webAppMount.length()), true);
            if (f != null && (list = f.listFiles()) != null) {
                for (File entry : list) {
                    StringBuilder sb = new StringBuilder(path2);
                    if (path2.charAt(path2.length() - 1) != '/') {
                        sb.append('/');
                    }
                    sb.append(entry.getName());
                    if (entry.isDirectory()) {
                        sb.append('/');
                    }
                    result.add(sb.toString());
                }
            }
        } else {
            if (!path2.endsWith("/")) {
                path2 = path2 + "/";
            }
            if (webAppMount.startsWith(path2)) {
                int i = webAppMount.indexOf(47, path2.length());
                if (i == -1) {
                    result.add(webAppMount + "/");
                } else {
                    result.add(webAppMount.substring(0, i + 1));
                }
            }
        }
        result.setLocked(true);
        return result;
    }

    @Override
    public boolean mkdir(String path2) {
        this.checkPath(path2);
        if (this.isReadOnly()) {
            return false;
        }
        String webAppMount = this.getWebAppMount();
        if (path2.startsWith(webAppMount)) {
            File f = this.file(path2.substring(webAppMount.length()), false);
            if (f == null) {
                return false;
            }
            return f.mkdir();
        }
        return false;
    }

    @Override
    public boolean write(String path2, InputStream is, boolean overwrite) {
        this.checkPath(path2);
        if (is == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (path2.endsWith("/")) {
            return false;
        }
        File dest = null;
        String webAppMount = this.getWebAppMount();
        if (path2.startsWith(webAppMount)) {
            dest = this.file(path2.substring(webAppMount.length()), false);
            if (dest == null) {
                return false;
            }
        } else {
            return false;
        }
        if (dest.exists() && !overwrite) {
            return false;
        }
        try {
            if (overwrite) {
                Files.copy(is, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(is, dest.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    @Override
    protected void checkType(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(sm.getString("dirResourceSet.notDirectory", this.getBase(), File.separator, this.getInternalPath()));
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        File mf;
        super.initInternal();
        if (this.getWebAppMount().equals("") && (mf = this.file("META-INF/MANIFEST.MF", true)) != null && mf.isFile()) {
            try (FileInputStream fis = new FileInputStream(mf);){
                this.setManifest(new Manifest(fis));
            }
            catch (IOException e) {
                log.warn(sm.getString("dirResourceSet.manifestFail", mf.getAbsolutePath()), e);
            }
        }
    }
}

