/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.helper;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.auth.defaultadapter.constant.AuthAdapterErrorCode;
import io.mosip.kernel.auth.defaultadapter.helper.ValidateTokenHelper;
import io.mosip.kernel.core.authmanager.authadapter.model.MosipUserDto;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Lazy
@Component
public class VertxTokenValidationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxTokenValidationHelper.class);
    @Value(value="${auth.server.admin.validate.url:}")
    private String adminValidateUrl;
    @Value(value="${auth.server.admin.offline.vertx.token.validate:true}")
    private boolean offlineTokenValidate;
    @Value(value="${spring.profiles.active:}")
    String activeProfile;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ValidateTokenHelper validateTokenHelper;

    public MosipUserDto getTokenValidatedVertxUserResponse(RestTemplate restTemplate, RoutingContext routingContext, String[] roles) throws JsonParseException, JsonMappingException, IOException {
        HttpServerRequest httpRequest = routingContext.request();
        String token = null;
        String cookies = httpRequest.getHeader("Cookie");
        if (cookies != null && !cookies.isEmpty() && cookies.contains("Authorization=")) {
            token = cookies.replace("Authorization=", "").trim();
        }
        if (token == null || token.isEmpty()) {
            this.sendErrors(routingContext, AuthAdapterErrorCode.UNAUTHORIZED, 401);
            return null;
        }
        token = token.split(";")[0];
        MosipUserDto mosipUserDto = null;
        mosipUserDto = !this.offlineTokenValidate ? this.doOnlineTokenValidation(token, restTemplate, routingContext) : this.doOfflineTokenValidation(token, restTemplate, routingContext);
        if (Objects.isNull(mosipUserDto)) {
            return null;
        }
        boolean isAuthorized = false;
        String[] authorities = mosipUserDto.getRole().split(",");
        block0: for (String role : roles) {
            for (String authority : authorities) {
                if (!role.equals(authority)) continue;
                isAuthorized = true;
                continue block0;
            }
        }
        if (!isAuthorized) {
            this.sendErrors(routingContext, AuthAdapterErrorCode.FORBIDDEN, 403);
            return null;
        }
        return mosipUserDto;
    }

    private MosipUserDto doOnlineTokenValidation(String token, RestTemplate restTemplate, RoutingContext routingContext) throws JsonParseException, JsonMappingException, IOException {
        ImmutablePair<HttpStatus, MosipUserDto> validateResp = this.validateTokenHelper.doOnlineTokenValidation(token, restTemplate);
        if (validateResp.getLeft() == HttpStatus.EXPECTATION_FAILED) {
            this.sendErrors(routingContext, AuthAdapterErrorCode.CONNECT_EXCEPTION, 500);
        }
        if (validateResp.getLeft() == HttpStatus.UNAUTHORIZED) {
            this.sendErrors(routingContext, AuthAdapterErrorCode.UNAUTHORIZED, 401);
        }
        if (validateResp.getLeft() == HttpStatus.FORBIDDEN) {
            this.sendErrors(routingContext, AuthAdapterErrorCode.FORBIDDEN, 403);
        }
        if (validateResp.getLeft() != HttpStatus.OK) {
            this.sendErrors(routingContext, AuthAdapterErrorCode.UNAUTHORIZED, 401);
        }
        return (MosipUserDto)validateResp.getRight();
    }

    private MosipUserDto doOfflineTokenValidation(String token, RestTemplate restTemplate, RoutingContext routingContext) throws JsonParseException, JsonMappingException, IOException {
        if (this.activeProfile.equalsIgnoreCase("local")) {
            return this.validateTokenHelper.doOfflineLocalTokenValidation(token);
        }
        return this.doOfflineEnvTokenValidation(token, restTemplate, routingContext);
    }

    private MosipUserDto doOfflineEnvTokenValidation(String jwtToken, RestTemplate restTemplate, RoutingContext routingContext) throws JsonParseException, JsonMappingException, IOException {
        DecodedJWT decodedJWT = JWT.decode((String)jwtToken);
        PublicKey publicKey = this.validateTokenHelper.getPublicKey(decodedJWT);
        if (Objects.isNull(publicKey)) {
            return this.doOnlineTokenValidation(jwtToken, restTemplate, routingContext);
        }
        ImmutablePair<Boolean, AuthAdapterErrorCode> validateResp = this.validateTokenHelper.isTokenValid(decodedJWT, publicKey);
        if (validateResp.getLeft() == Boolean.FALSE) {
            int httpStatusCode = validateResp.getRight() == AuthAdapterErrorCode.UNAUTHORIZED ? 401 : 403;
            this.sendErrors(routingContext, (AuthAdapterErrorCode)((Object)validateResp.getRight()), httpStatusCode);
            return null;
        }
        return this.validateTokenHelper.buildMosipUser(decodedJWT, jwtToken);
    }

    private void sendErrors(RoutingContext routingContext, AuthAdapterErrorCode errorCode, int statusCode) {
        ArrayList<ServiceError> errors = new ArrayList<ServiceError>();
        ServiceError error = new ServiceError(errorCode.getErrorCode(), errorCode.getErrorMessage());
        LOGGER.error(error.getMessage());
        errors.add(error);
        this.sendErrors(routingContext, errors, statusCode);
    }

    private void sendErrors(RoutingContext routingContext, List<ServiceError> errors, int statusCode) {
        ResponseWrapper errorResponse = new ResponseWrapper();
        errorResponse.getErrors().addAll(errors);
        this.objectMapper.registerModule(new JavaTimeModule());
        if (routingContext.getBodyAsJson() != null) {
            try {
                JsonNode reqNode = this.objectMapper.readTree(routingContext.getBodyAsJson().toString());
                errorResponse.setId(reqNode.path("id").asText());
                errorResponse.setVersion(reqNode.path("version").asText());
            }
            catch (IOException exception) {
                LOGGER.error(exception.getMessage());
            }
        }
        try {
            routingContext.response().putHeader("content-type", "application/json").setStatusCode(statusCode).end(this.objectMapper.writeValueAsString(errorResponse));
        }
        catch (JsonProcessingException exception) {
            LOGGER.error(exception.getMessage());
        }
    }
}

