/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.mosip.kernel.auth.defaultadapter.constant.AuthAdapterErrorCode;
import io.mosip.kernel.auth.defaultadapter.exception.AuthRestException;
import io.mosip.kernel.core.exception.ExceptionUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class TokenHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenHelper.class);
    @Value(value="${auth.server.admin.issuer.uri:}")
    private String issuerURI;
    @Value(value="${auth.server.admin.issuer.internal.uri:}")
    private String issuerInternalURI;
    @Autowired
    private ObjectMapper mapper;
    @Value(value="#{${mosip.kernel.auth.appids.realm.map}}")
    private Map<String, String> realmMap;
    @Value(value="${auth.server.admin.oidc.token.path:/protocol/openid-connect/token}")
    private String tokenPath;

    public String getClientToken(String clientId, String clientSecret, String appId, RestTemplate restTemplate) {
        if ("".equals(this.issuerURI)) {
            LOGGER.warn("OIDC Service URL is not available in config file, not requesting for new auth token.");
            return null;
        }
        this.issuerInternalURI = this.issuerInternalURI.trim().isEmpty() ? this.issuerURI : this.issuerInternalURI;
        LOGGER.info("Requesting for new Token for the provided OIDC Service: {}", (Object)this.issuerInternalURI);
        HttpHeaders headers2 = new HttpHeaders();
        headers2.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap<String, String> valueMap = new LinkedMultiValueMap<String, String>();
        valueMap.add("grant_type", "client_credentials");
        valueMap.add("client_id", clientId);
        valueMap.add("client_secret", clientSecret);
        ResponseEntity<String> response = null;
        try {
            HttpEntity request = new HttpEntity(valueMap, headers2);
            String realm = this.getRealmIdFromAppId(appId);
            if (Objects.isNull(realm)) {
                return null;
            }
            String tokenUrl = this.issuerInternalURI + realm + this.tokenPath;
            response = restTemplate.postForEntity(tokenUrl, request, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            LOGGER.error("error connecting to auth service {}", (Object)e.getResponseBodyAsString());
        }
        if (response == null) {
            LOGGER.error("error connecting to auth service {}", (Object)AuthAdapterErrorCode.CANNOT_CONNECT_TO_AUTH_SERVICE.getErrorMessage());
            return null;
        }
        String responseBody = (String)response.getBody();
        List validationErrorList = ExceptionUtils.getServiceErrorList((String)responseBody);
        if (!validationErrorList.isEmpty()) {
            throw new AuthRestException(validationErrorList);
        }
        try {
            JsonNode jsonNode = this.mapper.readTree(responseBody);
            String accessToken = jsonNode.get("access_token").asText();
            if (Objects.nonNull(accessToken)) {
                LOGGER.info("Found Token in response body and returning the Token");
                return accessToken;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error Parsing Response data {}", (Object)e.getMessage(), (Object)e);
        }
        LOGGER.error("Error connecting to OIDC service (RestTemplate) {} or UNKNOWN Error.", (Object)AuthAdapterErrorCode.CANNOT_CONNECT_TO_AUTH_SERVICE.getErrorMessage());
        return null;
    }

    public String getClientToken(String clientId, String clientSecret, String appId, WebClient webClient) {
        if ("".equals(this.issuerURI)) {
            LOGGER.warn("OIDC Service URL is not available in config file, not requesting for new auth token.");
            return null;
        }
        this.issuerInternalURI = this.issuerInternalURI.trim().isEmpty() ? this.issuerURI : this.issuerInternalURI;
        LOGGER.info("Requesting for new Token for the provided OIDC Service(WebClient): {}", (Object)this.issuerInternalURI);
        LinkedMultiValueMap<String, String> valueMap = new LinkedMultiValueMap<String, String>();
        valueMap.add("grant_type", "client_credentials");
        valueMap.add("client_id", clientId);
        valueMap.add("client_secret", clientSecret);
        String realm = this.getRealmIdFromAppId(appId);
        if (Objects.isNull(realm)) {
            return null;
        }
        String tokenUrl = this.issuerInternalURI + realm + this.tokenPath;
        ClientResponse response = ((WebClient.RequestBodySpec)webClient.method(HttpMethod.POST).uri(UriComponentsBuilder.fromUriString(tokenUrl).toUriString(), new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body(BodyInserters.fromFormData(valueMap)).exchange().block();
        if (response != null && response.statusCode() == HttpStatus.OK) {
            ObjectNode responseBody = response.bodyToMono(ObjectNode.class).block();
            String accessToken = null;
            if (responseBody != null) {
                accessToken = responseBody.get("access_token").asText();
            }
            if (Objects.nonNull(accessToken)) {
                LOGGER.info("Found Token in response body and returning the Token(WebClient)");
                return accessToken;
            }
        }
        LOGGER.error("Error connecting to OIDC service (WebClient) {} or UNKNOWN Error.", (Object)AuthAdapterErrorCode.CANNOT_CONNECT_TO_AUTH_SERVICE.getErrorMessage());
        return null;
    }

    private String getRealmIdFromAppId(String appId) {
        if (this.realmMap.get(appId) != null) {
            return this.realmMap.get(appId).toLowerCase();
        }
        LOGGER.warn("Realm not configured in configuration for appId: " + appId + ", not requesting for new auth token.");
        return null;
    }
}

