/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.handler;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.mosip.kernel.auth.defaultadapter.config.Generated;
import io.mosip.kernel.auth.defaultadapter.config.RestTemplateInterceptor;
import io.mosip.kernel.auth.defaultadapter.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultadapter.helper.VertxTokenValidationHelper;
import io.mosip.kernel.core.authmanager.authadapter.model.AuthUserDetails;
import io.mosip.kernel.core.authmanager.authadapter.model.MosipUserDto;
import io.mosip.kernel.core.authmanager.authadapter.spi.VertxAuthenticationProvider;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Lazy
@Component
public class VertxAuthHandler
implements VertxAuthenticationProvider {
    @Autowired
    private RestTemplateInterceptor restInterceptor;
    private RestTemplate restTemplate = null;
    @Autowired
    private VertxTokenValidationHelper validationHelper;
    private static final String DEFAULTADMIN_MOSIP_IO = "defaultadmin@mosip.io";
    @Value(value="${mosip.kernel.auth.adapter.ssl-bypass:true}")
    private boolean sslBypass;

    @PostConstruct
    void init() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().disableCookieManagement();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        if (this.sslBypass) {
            TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
            SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
            httpClientBuilder.setSSLSocketFactory(csf);
        }
        requestFactory.setHttpClient(httpClientBuilder.build());
        ArrayList<ClientHttpRequestInterceptor> list = new ArrayList<ClientHttpRequestInterceptor>();
        list.add(this.restInterceptor);
        this.restTemplate = new RestTemplate(requestFactory);
        this.restTemplate.setInterceptors(list);
    }

    @Generated
    public void addCorsFilter(HttpServer httpServer, Vertx vertx) {
        Router router = Router.router((Vertx)vertx);
        router.route().handler(routingContext -> {
            HttpServerResponse httpServerResponse = routingContext.response();
            httpServerResponse.putHeader("Cache-Control", "no-store, no-cache,max-age=0, must-revalidate").putHeader("Pragma", "no-cache").putHeader("X-Content-Type-Options", "nosniff").putHeader("Strict-Transport-Security", "max-age=15768000; includeSubDomains").putHeader("X-Download-Options", "noopen").putHeader("X-XSS-Protection", "1; mode=block").putHeader("X-FRAME-OPTIONS", "DENY");
            routingContext.next();
        });
        httpServer.requestHandler((Handler)router);
    }

    @Generated
    public void addAuthFilter(Router router, String path2, HttpMethod httpMethod, String commaSepratedRoles) {
        Objects.requireNonNull(httpMethod, "Http Method Cannot Be Null");
        Route filterRoute = router.route(httpMethod, path2);
        filterRoute.handler(routingContext -> this.tokenValidation((RoutingContext)routingContext, commaSepratedRoles));
    }

    @Generated
    public void addAuthFilter(RoutingContext routingContext, String commaSepratedRoles) {
        this.tokenValidation(routingContext, commaSepratedRoles);
    }

    private void tokenValidation(RoutingContext routingContext, String commaSepratedRoles) {
        try {
            if (EmptyCheckUtils.isNullEmpty((String)commaSepratedRoles)) {
                throw new NullPointerException("Roles Cannot Be Empty or Null");
            }
            String[] roles = commaSepratedRoles.split(",");
            Object token = this.validateToken(routingContext, roles);
            if (!((String)token).isEmpty()) {
                HttpServerResponse httpServerResponse = routingContext.response();
                if (!((String)token).startsWith("Authorization=")) {
                    token = "Authorization=" + (String)token;
                }
                httpServerResponse.putHeader("Set-Cookie", (String)token);
                routingContext.next();
            }
        }
        catch (Exception e) {
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), e);
        }
    }

    private String validateToken(RoutingContext routingContext, String[] roles) throws RestClientException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JsonParseException, JsonMappingException, JsonProcessingException, IOException {
        MosipUserDto mosipUserDto = this.validationHelper.getTokenValidatedVertxUserResponse(this.restTemplate, routingContext, roles);
        if (Objects.isNull(mosipUserDto)) {
            return "";
        }
        AuthUserDetails authUserDetails = new AuthUserDetails(mosipUserDto, mosipUserDto.getToken());
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(authUserDetails, authUserDetails.getPassword(), null);
        routingContext.put("RoutingCtxUserName", (Object)mosipUserDto);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        return mosipUserDto.getToken();
    }

    public String getContextUser(RoutingContext routingContext) {
        MosipUserDto mosipUser = (MosipUserDto)routingContext.get("RoutingCtxUserName");
        return mosipUser == null ? DEFAULTADMIN_MOSIP_IO : mosipUser.getUserId();
    }
}

