/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.mosip.kernel.auth.defaultadapter.config.NoAuthenticationEndPoint;
import io.mosip.kernel.auth.defaultadapter.constant.AuthAdapterErrorCode;
import io.mosip.kernel.auth.defaultadapter.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultadapter.model.AuthToken;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class AuthFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthFilter.class);
    private NoAuthenticationEndPoint noAuthenticationEndPoint;
    private ObjectMapper mapper;
    private List<String> allowedHttpMethods;

    public AuthFilter(RequestMatcher requiresAuthenticationRequestMatcher, NoAuthenticationEndPoint noAuthenticationEndPoint, Environment environment2) {
        super(requiresAuthenticationRequestMatcher);
        this.noAuthenticationEndPoint = noAuthenticationEndPoint;
        String applName = this.getApplicationName(environment2);
        this.allowedHttpMethods = environment2.getProperty("mosip.service.exclude.auth.allowed.method." + applName, List.class, environment2.getProperty("mosip.service.exclude.auth.allowed.method", List.class, Collections.singletonList("GET")));
        this.mapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new AfterburnerModule())).build();
        this.mapper.registerModule(new JavaTimeModule());
    }

    @Override
    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        if (this.isPresent(request, this.noAuthenticationEndPoint.getGlobal().getEndPoints())) {
            return false;
        }
        boolean isValid = this.isValid(this.noAuthenticationEndPoint);
        if (isValid && request.getServletContext().getContextPath().equalsIgnoreCase(this.noAuthenticationEndPoint.getServiceContext())) {
            return !this.allowedHttpMethods.contains(request.getMethod()) || !this.isPresent(request, this.noAuthenticationEndPoint.getService().getEndPoints());
        }
        return true;
    }

    private boolean isPresent(HttpServletRequest request, List<String> endPoints) {
        return endPoints.stream().filter(pattern -> new AntPathRequestMatcher((String)pattern).matches(request)).findFirst().isPresent();
    }

    private boolean isValid(NoAuthenticationEndPoint noAuthenticationEndPoint) {
        if (noAuthenticationEndPoint.getServiceContext() == null || noAuthenticationEndPoint.getServiceContext().isEmpty()) {
            return false;
        }
        return noAuthenticationEndPoint.getService() != null || noAuthenticationEndPoint.getService().getEndPoints() != null || !noAuthenticationEndPoint.getService().getEndPoints().isEmpty();
    }

    @Override
    public Authentication attemptAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws AuthenticationException, JsonProcessingException, IOException {
        String token = null;
        Cookie[] cookies = null;
        try {
            cookies = httpServletRequest.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().contains("Authorization")) continue;
                    LOGGER.debug("extract token from cookie named " + cookie.getName());
                    token = cookie.getValue();
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("extract token from cookie failed for request " + httpServletRequest.getRequestURI());
        }
        if (token == null) {
            ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
            ServiceError error = new ServiceError(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), "Authentication Failed");
            errorResponse.getErrors().add(error);
            httpServletResponse.setStatus(HttpStatus.UNAUTHORIZED.value());
            httpServletResponse.setContentType("application/json");
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.getWriter().write(this.convertObjectToJson(errorResponse));
            LOGGER.error("\n\n Exception : Authorization token not present > " + httpServletRequest.getRequestURL() + "\n\n");
            return null;
        }
        AuthToken authToken = new AuthToken(token);
        LOGGER.debug("Extracted auth token for request " + httpServletRequest.getRequestURL());
        return this.getAuthenticationManager().authenticate(authToken);
    }

    @Override
    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        super.successfulAuthentication(request, response, chain, authResult);
        chain.doFilter(request, response);
    }

    @Override
    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        AuthManagerException exception = (AuthManagerException)failed;
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(request);
        if (exception.getList().size() != 0) {
            errorResponse.getErrors().addAll(exception.getList());
        } else {
            ServiceError error = new ServiceError(AuthAdapterErrorCode.UNAUTHORIZED.getErrorCode(), "Authentication Failed");
            errorResponse.getErrors().add(error);
        }
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        ExceptionUtils.logRootCause((Throwable)failed);
        response.getWriter().write(this.convertObjectToJson(errorResponse));
    }

    private ResponseWrapper<ServiceError> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponsetime(LocalDateTime.now(ZoneId.of("UTC")));
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        if (EmptyCheckUtils.isNullEmpty(requestBody)) {
            return responseWrapper;
        }
        JsonNode reqNode = this.mapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }

    private String convertObjectToJson(Object object) throws JsonProcessingException {
        if (object == null) {
            return null;
        }
        return this.mapper.writeValueAsString(object);
    }

    private String getApplicationName(Environment environment2) {
        String appNames = environment2.getProperty("spring.application.name");
        if (!EmptyCheckUtils.isNullEmpty((String)appNames)) {
            List appNamesList = Stream.of(appNames.split(",")).collect(Collectors.toList());
            return (String)appNamesList.get(0);
        }
        throw new RuntimeException("property spring.application.name not found");
    }
}

