/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import io.mosip.kernel.auth.defaultadapter.constant.AuthAdapterErrorCode;
import io.mosip.kernel.auth.defaultadapter.exception.AuthAdapterException;
import io.mosip.kernel.auth.defaultadapter.helper.TokenHelper;
import io.mosip.kernel.auth.defaultadapter.helper.TokenValidationHelper;
import io.mosip.kernel.auth.defaultadapter.model.TokenHolder;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;

public class SelfTokenRestInterceptor
implements ClientHttpRequestInterceptor {
    private String clientID;
    private String clientSecret;
    private String appID;
    private TokenHolder<String> cachedToken;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfTokenRestInterceptor.class);
    private RestTemplate restTemplate;
    private TokenHelper tokenHelper;
    private TokenValidationHelper tokenValidationHelper;

    public SelfTokenRestInterceptor(Environment environment2, RestTemplate restTemplate, TokenHolder<String> cachedToken, TokenHelper tokenHelper, TokenValidationHelper tokenValidationHelper, String applName) {
        this.clientID = environment2.getProperty("mosip.iam.adapter.clientid." + applName, environment2.getProperty("mosip.iam.adapter.clientid", ""));
        this.clientSecret = environment2.getProperty("mosip.iam.adapter.clientsecret." + applName, environment2.getProperty("mosip.iam.adapter.clientsecret", ""));
        this.appID = environment2.getProperty("mosip.iam.adapter.appid." + applName, environment2.getProperty("mosip.iam.adapter.appid", ""));
        this.cachedToken = cachedToken;
        this.restTemplate = restTemplate;
        this.tokenHelper = tokenHelper;
        this.tokenValidationHelper = tokenValidationHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body2, ClientHttpRequestExecution execution) throws IOException {
        if (this.cachedToken.getToken() == null) {
            String authToken = this.tokenHelper.getClientToken(this.clientID, this.clientSecret, this.appID, this.restTemplate);
            if (Objects.isNull(authToken)) {
                LOGGER.error("there is some issue with getting token with clienid and secret");
                throw new AuthAdapterException(AuthAdapterErrorCode.SELF_AUTH_TOKEN_NULL.getErrorCode(), AuthAdapterErrorCode.SELF_AUTH_TOKEN_NULL.getErrorMessage());
            }
            this.cachedToken.setToken(authToken);
        }
        request.getHeaders().add("Cookie", "Authorization=" + this.cachedToken.getToken());
        ClientHttpResponse clientHttpResponse = execution.execute(request, body2);
        if (clientHttpResponse.getStatusCode() != HttpStatus.UNAUTHORIZED) {
            return clientHttpResponse;
        }
        SelfTokenRestInterceptor selfTokenRestInterceptor = this;
        synchronized (selfTokenRestInterceptor) {
            if (!this.isTokenValid(this.cachedToken.getToken())) {
                String authToken = this.tokenHelper.getClientToken(this.clientID, this.clientSecret, this.appID, this.restTemplate);
                this.cachedToken.setToken(authToken);
            }
        }
        List cookies = request.getHeaders().get("Cookie");
        if (cookies != null && !cookies.isEmpty()) {
            cookies = cookies.stream().filter(str -> !str.contains("Authorization=")).collect(Collectors.toList());
        }
        request.getHeaders().replace("Cookie", cookies);
        request.getHeaders().add("Cookie", "Authorization=" + this.cachedToken.getToken());
        return execution.execute(request, body2);
    }

    private boolean isTokenValid(String authToken) {
        return Objects.nonNull(this.tokenValidationHelper.getOnlineTokenValidatedUserResponse(authToken, this.restTemplate));
    }
}

