/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.mosip.kernel.auth.defaultadapter.helper.TokenHelper;
import io.mosip.kernel.auth.defaultadapter.model.TokenHolder;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.util.DateUtils;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.reactive.function.client.WebClient;

public class SelfTokenRenewalTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfTokenRenewalTaskExecutor.class);
    private String clientID;
    private String clientSecret;
    private String appID;
    @Value(value="${mosip.iam.adapter.token-expiry-check-frequency:5}")
    private int tokenExpiryCheckFrequency;
    @Value(value="${mosip.iam.adapter.renewal-before-expiry-interval:5}")
    private int renewalBeforeExpiryInterval;
    @Value(value="${mosip.iam.adapter.self-token-renewal-enable:true}")
    private boolean isRenewalEnable;
    private TokenHolder<String> cachedTokenObject;
    private TokenHelper tokenHelper;
    private WebClient webClient;

    public SelfTokenRenewalTaskExecutor(TokenHolder<String> cachedTokenObject, WebClient webClient, TokenHelper tokenHelper, Environment environment2, String applName) {
        this.cachedTokenObject = cachedTokenObject;
        this.webClient = webClient;
        this.tokenHelper = tokenHelper;
        this.clientID = environment2.getProperty("mosip.iam.adapter.clientid." + applName, environment2.getProperty("mosip.iam.adapter.clientid", ""));
        this.clientSecret = environment2.getProperty("mosip.iam.adapter.clientsecret." + applName, environment2.getProperty("mosip.iam.adapter.clientsecret", ""));
        this.appID = environment2.getProperty("mosip.iam.adapter.appid." + applName, environment2.getProperty("mosip.iam.adapter.appid", ""));
    }

    @PostConstruct
    private void init() {
        if (this.isRenewalEnable) {
            ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
            taskScheduler.setPoolSize(1);
            taskScheduler.initialize();
            taskScheduler.scheduleAtFixedRate((Runnable)new SelfTokenHandlerTask(), TimeUnit.MINUTES.toMillis(this.tokenExpiryCheckFrequency));
        }
    }

    private boolean isTokenValid(String authToken) {
        try {
            DecodedJWT decodedJWT = JWT.decode((String)authToken);
            Map claims = decodedJWT.getClaims();
            LocalDateTime expiryTime = DateUtils.convertUTCToLocalDateTime((String)DateUtils.getUTCTimeFromDate((Date)decodedJWT.getExpiresAt()));
            if (!DateUtils.before((LocalDateTime)DateUtils.getUTCCurrentDateTime().plusMinutes(this.renewalBeforeExpiryInterval), (LocalDateTime)expiryTime)) {
                return false;
            }
            return ((Claim)claims.get("clientId")).asString().equals(this.clientID);
        }
        catch (JWTDecodeException e) {
            LOGGER.error("JWT DECODE EXCEPTION ::".concat(e.getMessage()).concat(ExceptionUtils.getStackTrace((Throwable)e)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage().concat(ExceptionUtils.getStackTrace((Throwable)e)));
        }
        return false;
    }

    private class SelfTokenHandlerTask
    implements Runnable {
        private SelfTokenHandlerTask() {
        }

        @Override
        public void run() {
            if (SelfTokenRenewalTaskExecutor.this.cachedTokenObject.getToken() == null || !SelfTokenRenewalTaskExecutor.this.isTokenValid(SelfTokenRenewalTaskExecutor.this.cachedTokenObject.getToken())) {
                String authToken = SelfTokenRenewalTaskExecutor.this.tokenHelper.getClientToken(SelfTokenRenewalTaskExecutor.this.clientID, SelfTokenRenewalTaskExecutor.this.clientSecret, SelfTokenRenewalTaskExecutor.this.appID, SelfTokenRenewalTaskExecutor.this.webClient);
                SelfTokenRenewalTaskExecutor.this.cachedTokenObject.setToken(authToken);
            }
        }
    }
}

