/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import io.mosip.kernel.auth.defaultadapter.config.AuthEntryPoint;
import io.mosip.kernel.auth.defaultadapter.config.NoAuthenticationEndPoint;
import io.mosip.kernel.auth.defaultadapter.filter.AuthFilter;
import io.mosip.kernel.auth.defaultadapter.filter.CorsFilter;
import io.mosip.kernel.auth.defaultadapter.handler.AuthHandler;
import io.mosip.kernel.auth.defaultadapter.handler.AuthSuccessHandler;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Order(value=2)
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfig.class);
    @Value(value="${mosip.security.csrf-enable:false}")
    private boolean isCSRFEnable;
    @Value(value="${mosip.security.cors-enable:false}")
    private boolean isCORSEnable;
    @Value(value="${mosip.security.origins:localhost:8080}")
    private String origins;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AuthHandler authProvider;
    @Autowired
    private Environment environment;
    @Autowired
    private NoAuthenticationEndPoint noAuthenticationEndPoint;

    @Override
    @Bean
    public AuthenticationManager authenticationManager() {
        ArrayList<AuthenticationProvider> authProviders = new ArrayList<AuthenticationProvider>();
        String applName = this.getApplicationName();
        List otherAuthProviders = this.environment.getProperty("mosip.security.authentication.provider.beans.list." + applName, List.class, Collections.EMPTY_LIST);
        otherAuthProviders.stream().forEach(beanName -> {
            try {
                if (Objects.nonNull(beanName) && !beanName.equals("")) {
                    authProviders.add(this.applicationContext.getBean((String)beanName, AbstractUserDetailsAuthenticationProvider.class));
                    LOGGER.info("Added Custom Auth Provider Bean in the list {} ", beanName);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error Adding bean to providers list: " + beanName, ex);
            }
        });
        authProviders.add(this.authProvider);
        return new ProviderManager(authProviders);
    }

    @Bean
    public AbstractAuthenticationProcessingFilter authFilter() {
        AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher("*");
        AuthFilter filter = new AuthFilter(requestMatcher, this.noAuthenticationEndPoint, this.environment);
        filter.setAuthenticationManager(this.authenticationManager());
        filter.setAuthenticationSuccessHandler(new AuthSuccessHandler());
        return filter;
    }

    @Bean
    public FilterRegistrationBean<AbstractAuthenticationProcessingFilter> registration(AbstractAuthenticationProcessingFilter filter) {
        FilterRegistrationBean<AbstractAuthenticationProcessingFilter> registration = new FilterRegistrationBean<AbstractAuthenticationProcessingFilter>(filter, new ServletRegistrationBean[0]);
        registration.setEnabled(false);
        return registration;
    }

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        if (!this.isCSRFEnable) {
            http = (HttpSecurity)http.csrf().disable();
        }
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers("*")).authenticated().and()).exceptionHandling().authenticationEntryPoint(new AuthEntryPoint()).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.addFilterBefore((Filter)this.authFilter(), UsernamePasswordAuthenticationFilter.class);
        if (this.isCORSEnable) {
            http.addFilterBefore((Filter)new CorsFilter(this.origins), AuthFilter.class);
        }
        http.headers().cacheControl();
        http.headers().frameOptions().sameOrigin();
    }

    private String getApplicationName() {
        String appNames = this.environment.getProperty("spring.application.name");
        if (!EmptyCheckUtils.isNullEmpty((String)appNames)) {
            List appNamesList = Stream.of(appNames.split(",")).collect(Collectors.toList());
            return (String)appNamesList.get(0);
        }
        throw new RuntimeException("property spring.application.name is not found");
    }
}

