/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import io.mosip.kernel.core.authmanager.authadapter.model.AuthUserDetails;
import java.io.IOException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.core.context.SecurityContextHolder;

public class RequesterTokenRestInterceptor
implements ClientHttpRequestInterceptor {
    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body2, ClientHttpRequestExecution execution) throws IOException {
        this.addHeadersToRequest(request, body2);
        return execution.execute(request, body2);
    }

    private void addHeadersToRequest(HttpRequest httpRequest, byte[] bytes) {
        HttpHeaders headers2 = httpRequest.getHeaders();
        AuthUserDetails authUserDetails = this.getAuthUserDetails();
        if (authUserDetails != null) {
            headers2.set("Cookie", "Authorization=" + authUserDetails.getToken());
        }
    }

    private AuthUserDetails getAuthUserDetails() {
        AuthUserDetails authUserDetails = null;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof AuthUserDetails) {
            authUserDetails = (AuthUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        }
        return authUserDetails;
    }
}

