/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultadapter.config;

import io.mosip.kernel.auth.defaultadapter.config.RequesterTokenRestInterceptor;
import io.mosip.kernel.auth.defaultadapter.config.RestTemplateInterceptor;
import io.mosip.kernel.auth.defaultadapter.config.SelfTokenExchangeFilterFunction;
import io.mosip.kernel.auth.defaultadapter.config.SelfTokenRenewalTaskExecutor;
import io.mosip.kernel.auth.defaultadapter.config.SelfTokenRestInterceptor;
import io.mosip.kernel.auth.defaultadapter.helper.TokenHelper;
import io.mosip.kernel.auth.defaultadapter.helper.TokenValidationHelper;
import io.mosip.kernel.auth.defaultadapter.model.TokenHolder;
import io.mosip.kernel.core.authmanager.authadapter.model.AuthUserDetails;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerExchangeFilterFunction;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@EnableScheduling
public class BeanConfig {
    @Autowired
    private TokenHelper tokenHelper;
    @Autowired
    private Environment environment;
    @Autowired
    private RestTemplateInterceptor defaultInterceptor;
    @Value(value="${mosip.kernel.auth.adapter.ssl-bypass:true}")
    private boolean sslBypass;
    @Value(value="${mosip.kernel.http.default.restTemplate.max-connection-per-route:20}")
    private Integer defaultRestTemplateMaxConnectionPerRoute;
    @Value(value="${mosip.kernel.http.default.restTemplate.total-max-connections:100}")
    private Integer defaultRestTemplateTotalMaxConnections;
    @Value(value="${mosip.kernel.http.selftoken.restTemplate.max-connection-per-route:20}")
    private Integer selfTokenRestTemplateMaxConnectionPerRoute;
    @Value(value="${mosip.kernel.http.selftoken.restTemplate.total-max-connections:100}")
    private Integer selfTokenRestTemplateTotalMaxConnections;
    @Value(value="${mosip.kernel.http.plain.restTemplate.max-connection-per-route:20}")
    private Integer plainRestTemplateMaxConnectionPerRoute;
    @Value(value="${mosip.kernel.http.plain.restTemplate.total-max-connections:100}")
    private Integer plainRestTemplateTotalMaxConnections;
    @Autowired
    private TokenValidationHelper tokenValidationHelper;
    @Autowired(required=false)
    private LoadBalancerClient loadBalancerClient;

    @Bean
    public RestTemplate restTemplate() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setMaxConnPerRoute(this.defaultRestTemplateMaxConnectionPerRoute).setMaxConnTotal(this.defaultRestTemplateTotalMaxConnections).disableCookieManagement();
        RestTemplate restTemplate = null;
        if (this.sslBypass) {
            TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
            SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
            httpClientBuilder.setSSLSocketFactory(csf);
        }
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient(httpClientBuilder.build());
        restTemplate = new RestTemplate(requestFactory);
        restTemplate.setInterceptors(Collections.singletonList(new RequesterTokenRestInterceptor()));
        return restTemplate;
    }

    @Bean
    public RestTemplate plainRestTemplate() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setMaxConnPerRoute(this.plainRestTemplateMaxConnectionPerRoute).setMaxConnTotal(this.plainRestTemplateTotalMaxConnections).disableCookieManagement();
        Object restTemplate = null;
        if (this.sslBypass) {
            TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
            SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
            httpClientBuilder.setSSLSocketFactory(csf);
        }
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient(httpClientBuilder.build());
        RestTemplate template = new RestTemplate(requestFactory);
        template.setInterceptors(Collections.singletonList(this.defaultInterceptor));
        return template;
    }

    @Bean
    public TokenHolder<String> cachedTokenObject() {
        return new TokenHolder<String>();
    }

    @Bean
    public RestTemplate selfTokenRestTemplate(@Autowired @Qualifier(value="plainRestTemplate") RestTemplate plainRestTemplate, @Autowired TokenHolder<String> cachedTokenObject) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setMaxConnPerRoute(this.selfTokenRestTemplateMaxConnectionPerRoute).setMaxConnTotal(this.selfTokenRestTemplateTotalMaxConnections).disableCookieManagement();
        RestTemplate restTemplate = null;
        if (this.sslBypass) {
            TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
            SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
            httpClientBuilder.setSSLSocketFactory(csf);
        }
        String applName = this.getApplicationName();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient(httpClientBuilder.build());
        restTemplate = new RestTemplate(requestFactory);
        restTemplate.setInterceptors(Collections.singletonList(new SelfTokenRestInterceptor(this.environment, plainRestTemplate, cachedTokenObject, this.tokenHelper, this.tokenValidationHelper, applName)));
        return restTemplate;
    }

    @Bean
    public WebClient plainWebClient() {
        ExchangeFilterFunction filterFunction = this.loadBalancerClient != null ? new LoadBalancerExchangeFilterFunction(this.loadBalancerClient) : (req, next) -> next.exchange(req);
        return WebClient.builder().filter(filterFunction).build();
    }

    @Bean
    public SelfTokenRenewalTaskExecutor selfTokenRenewTaskExecutor(@Autowired TokenHolder<String> cachedTokenObject, @Autowired @Qualifier(value="plainWebClient") WebClient plainWebClient) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        String applName = this.getApplicationName();
        return new SelfTokenRenewalTaskExecutor(cachedTokenObject, plainWebClient, this.tokenHelper, this.environment, applName);
    }

    @Bean
    public WebClient webClient() {
        return WebClient.builder().filter((req, next) -> {
            ClientRequest filtered = null;
            if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof AuthUserDetails) {
                AuthUserDetails userDetail = (AuthUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                filtered = ClientRequest.from(req).header("Cookie", "Authorization=" + userDetail.getToken()).build();
            }
            return next.exchange(filtered);
        }).build();
    }

    @Bean
    public WebClient selfTokenWebClient(@Autowired @Qualifier(value="plainWebClient") WebClient plainWebClient, @Autowired TokenHolder<String> cachedTokenObject) {
        String applName = this.getApplicationName();
        return WebClient.builder().filter(new SelfTokenExchangeFilterFunction(this.environment, plainWebClient, cachedTokenObject, this.tokenHelper, this.tokenValidationHelper, applName)).build();
    }

    private String getApplicationName() {
        String appNames = this.environment.getProperty("spring.application.name");
        if (!EmptyCheckUtils.isNullEmpty((String)appNames)) {
            List appNamesList = Stream.of(appNames.split(",")).collect(Collectors.toList());
            return (String)appNamesList.get(0);
        }
        throw new RuntimeException("Property spring.application.name not found");
    }
}

