/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.crypto;

import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.crypto.SignatureProvider;
import io.jsonwebtoken.lang.Assert;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jce.ECNamedCurveTable;

public abstract class EllipticCurveProvider
extends SignatureProvider {
    private static final Map<SignatureAlgorithm, String> EC_CURVE_NAMES = EllipticCurveProvider.createEcCurveNames();

    private static Map<SignatureAlgorithm, String> createEcCurveNames() {
        HashMap<SignatureAlgorithm, String> m3 = new HashMap<SignatureAlgorithm, String>();
        m3.put(SignatureAlgorithm.ES256, "secp256r1");
        m3.put(SignatureAlgorithm.ES384, "secp384r1");
        m3.put(SignatureAlgorithm.ES512, "secp521r1");
        return m3;
    }

    protected EllipticCurveProvider(SignatureAlgorithm alg, Key key) {
        super(alg, key);
        Assert.isTrue(alg.isEllipticCurve(), "SignatureAlgorithm must be an Elliptic Curve algorithm.");
    }

    public static KeyPair generateKeyPair() {
        return EllipticCurveProvider.generateKeyPair(SignatureAlgorithm.ES512);
    }

    public static KeyPair generateKeyPair(SignatureAlgorithm alg) {
        return EllipticCurveProvider.generateKeyPair(alg, SignatureProvider.DEFAULT_SECURE_RANDOM);
    }

    public static KeyPair generateKeyPair(SignatureAlgorithm alg, SecureRandom random) {
        return EllipticCurveProvider.generateKeyPair("ECDSA", "BC", alg, random);
    }

    public static KeyPair generateKeyPair(String jcaAlgorithmName, String jcaProviderName, SignatureAlgorithm alg, SecureRandom random) {
        Assert.notNull((Object)alg, "SignatureAlgorithm argument cannot be null.");
        Assert.isTrue(alg.isEllipticCurve(), "SignatureAlgorithm argument must represent an Elliptic Curve algorithm.");
        try {
            KeyPairGenerator g2 = KeyPairGenerator.getInstance(jcaAlgorithmName, jcaProviderName);
            String paramSpecCurveName = EC_CURVE_NAMES.get((Object)alg);
            g2.initialize(ECNamedCurveTable.getParameterSpec(paramSpecCurveName), random);
            return g2.generateKeyPair();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to generate Elliptic Curve KeyPair: " + e.getMessage(), e);
        }
    }
}

