/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.ipc.netty.http.server.HttpServerRequest;

final class HttpPredicate
implements Predicate<HttpServerRequest>,
Function<Object, Map<String, String>> {
    final HttpVersion protocol;
    final HttpMethod method;
    final String uri;
    final UriPathTemplate template;

    public static Predicate<HttpServerRequest> delete(String uri) {
        return HttpPredicate.http(uri, null, HttpMethod.DELETE);
    }

    public static Predicate<HttpServerRequest> get(String uri) {
        return HttpPredicate.http(uri, null, HttpMethod.GET);
    }

    public static Predicate<HttpServerRequest> http(String uri, HttpVersion protocol, HttpMethod method2) {
        if (null == uri) {
            return null;
        }
        return new HttpPredicate(uri, protocol, method2);
    }

    public static Predicate<HttpServerRequest> post(String uri) {
        return HttpPredicate.http(uri, null, HttpMethod.POST);
    }

    public static Predicate<HttpServerRequest> prefix(String prefix) {
        return HttpPredicate.prefix(prefix, HttpMethod.GET);
    }

    public static Predicate<HttpServerRequest> prefix(String prefix, HttpMethod method2) {
        Objects.requireNonNull(prefix, "Prefix must be provided");
        String target = prefix.startsWith("/") ? prefix : "/".concat(prefix);
        return new HttpPrefixPredicate(target, method2);
    }

    public static Predicate<HttpServerRequest> put(String uri) {
        return HttpPredicate.http(uri, null, HttpMethod.PUT);
    }

    public HttpPredicate(String uri) {
        this(uri, null, null);
    }

    public HttpPredicate(String uri, HttpVersion protocol, HttpMethod method2) {
        this.protocol = protocol;
        this.uri = uri;
        this.method = method2;
        this.template = uri != null ? new UriPathTemplate(uri) : null;
    }

    @Override
    public Map<String, String> apply(Object key) {
        if (this.template == null) {
            return null;
        }
        Map<String, String> headers2 = this.template.match(key.toString());
        if (null != headers2 && !headers2.isEmpty()) {
            return headers2;
        }
        return null;
    }

    @Override
    public final boolean test(HttpServerRequest key) {
        return !(this.protocol != null && !this.protocol.equals(key.version()) || this.method != null && !this.method.equals(key.method()) || this.template != null && !this.template.matches(key.uri()));
    }

    static final class HttpPrefixPredicate
    implements Predicate<HttpServerRequest> {
        final HttpMethod method;
        final String prefix;

        public HttpPrefixPredicate(String prefix, HttpMethod method2) {
            this.prefix = prefix;
            this.method = method2;
        }

        @Override
        public boolean test(HttpServerRequest key) {
            return (this.method == null || this.method.equals(key.method())) && key.uri().startsWith(this.prefix);
        }
    }

    static final class UriPathTemplate {
        private static final Pattern FULL_SPLAT_PATTERN = Pattern.compile("[\\*][\\*]");
        private static final String FULL_SPLAT_REPLACEMENT = ".*";
        private static final Pattern NAME_SPLAT_PATTERN = Pattern.compile("\\{([^/]+?)\\}[\\*][\\*]");
        private static final String NAME_SPLAT_REPLACEMENT = "(?<%NAME%>.*)";
        private static final Pattern NAME_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
        private static final String NAME_REPLACEMENT = "(?<%NAME%>[^\\/]*)";
        private final List<String> pathVariables = new ArrayList<String>();
        private final HashMap<String, Matcher> matchers = new HashMap();
        private final HashMap<String, Map<String, String>> vars = new HashMap();
        private final Pattern uriPattern;

        public UriPathTemplate(String uriPattern) {
            String name;
            int i;
            String s2 = "^" + uriPattern;
            Matcher m3 = NAME_SPLAT_PATTERN.matcher(s2);
            while (m3.find()) {
                for (i = 1; i <= m3.groupCount(); ++i) {
                    name = m3.group(i);
                    this.pathVariables.add(name);
                    s2 = m3.replaceFirst(NAME_SPLAT_REPLACEMENT.replaceAll("%NAME%", name));
                    m3.reset(s2);
                }
            }
            m3 = NAME_PATTERN.matcher(s2);
            while (m3.find()) {
                for (i = 1; i <= m3.groupCount(); ++i) {
                    name = m3.group(i);
                    this.pathVariables.add(name);
                    s2 = m3.replaceFirst(NAME_REPLACEMENT.replaceAll("%NAME%", name));
                    m3.reset(s2);
                }
            }
            m3 = FULL_SPLAT_PATTERN.matcher(s2);
            while (m3.find()) {
                s2 = m3.replaceAll(FULL_SPLAT_REPLACEMENT);
                m3.reset(s2);
            }
            this.uriPattern = Pattern.compile(s2 + "$");
        }

        public boolean matches(String uri) {
            return this.matcher(uri).matches();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Map<String, String> match(String uri) {
            Map<String, String> pathParameters = this.vars.get(uri);
            if (null != pathParameters) {
                return pathParameters;
            }
            pathParameters = new HashMap<String, String>();
            Matcher m3 = this.matcher(uri);
            if (m3.matches()) {
                int i = 1;
                for (String name : this.pathVariables) {
                    String val = m3.group(i++);
                    pathParameters.put(name, val);
                }
            }
            HashMap<String, Map<String, String>> hashMap = this.vars;
            synchronized (hashMap) {
                this.vars.put(uri, pathParameters);
            }
            return pathParameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Matcher matcher(String uri) {
            Matcher m3 = this.matchers.get(uri);
            if (null == m3) {
                m3 = this.uriPattern.matcher(uri);
                HashMap<String, Matcher> hashMap = this.matchers;
                synchronized (hashMap) {
                    this.matchers.put(uri, m3);
                }
            }
            return m3;
        }
    }
}

