/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class FluxMapFuseable<T, R>
extends FluxOperator<T, R>
implements Fuseable {
    final Function<? super T, ? extends R> mapper;

    FluxMapFuseable(Flux<? extends T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public void subscribe(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            this.source.subscribe(new MapFuseableConditionalSubscriber<T, R>(cs, this.mapper));
            return;
        }
        this.source.subscribe(new MapFuseableSubscriber<T, R>(actual, this.mapper));
    }

    static final class MapFuseableConditionalSubscriber<T, R>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, R>,
    Fuseable.QueueSubscription<R> {
        final Fuseable.ConditionalSubscriber<? super R> actual;
        final Function<? super T, ? extends R> mapper;
        boolean done;
        Fuseable.QueueSubscription<T> s;
        int sourceMode;

        MapFuseableConditionalSubscriber(Fuseable.ConditionalSubscriber<? super R> actual, Function<? super T, ? extends R> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.s, s2)) {
                this.s = (Fuseable.QueueSubscription)s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                R v;
                if (this.done) {
                    Operators.onNextDropped(t, this.actual.currentContext());
                    return;
                }
                try {
                    v = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null value.");
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                    return;
                }
                this.actual.onNext(v);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            R v;
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return true;
            }
            try {
                v = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                return true;
            }
            return this.actual.tryOnNext(v);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public CoreSubscriber<? super R> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public R poll() {
            Object v = this.s.poll();
            if (v != null) {
                return Objects.requireNonNull(this.mapper.apply(v));
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m3;
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            this.sourceMode = m3 = this.s.requestFusion(requestedMode);
            return m3;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }

    static final class MapFuseableSubscriber<T, R>
    implements InnerOperator<T, R>,
    Fuseable.QueueSubscription<R> {
        final CoreSubscriber<? super R> actual;
        final Function<? super T, ? extends R> mapper;
        boolean done;
        Fuseable.QueueSubscription<T> s;
        int sourceMode;

        MapFuseableSubscriber(CoreSubscriber<? super R> actual, Function<? super T, ? extends R> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.s, s2)) {
                this.s = (Fuseable.QueueSubscription)s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                R v;
                if (this.done) {
                    Operators.onNextDropped(t, this.actual.currentContext());
                    return;
                }
                try {
                    v = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null value.");
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                    return;
                }
                this.actual.onNext(v);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super R> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public R poll() {
            Object v = this.s.poll();
            if (v != null) {
                return Objects.requireNonNull(this.mapper.apply(v));
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m3;
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            this.sourceMode = m3 = this.s.requestFusion(requestedMode);
            return m3;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }
}

