/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import io.undertow.server.HttpServerExchange;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.UndertowWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.UndertowWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import org.xnio.ChannelListener;
import reactor.core.publisher.Mono;

public class UndertowRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange2, WebSocketHandler handler, @Nullable String subProtocol) {
        ServerHttpRequest request = exchange2.getRequest();
        Assert.isInstanceOf(AbstractServerHttpRequest.class, request);
        HttpServerExchange httpExchange = (HttpServerExchange)((AbstractServerHttpRequest)request).getNativeRequest();
        Set<Object> protocols = subProtocol != null ? Collections.singleton(subProtocol) : Collections.emptySet();
        Hybi13Handshake handshake = new Hybi13Handshake(protocols, false);
        List<Hybi13Handshake> handshakes = Collections.singletonList(handshake);
        URI url = request.getURI();
        HttpHeaders headers2 = request.getHeaders();
        Mono<Principal> principal = exchange2.getPrincipal();
        HandshakeInfo info = new HandshakeInfo(url, headers2, principal, subProtocol);
        DataBufferFactory bufferFactory = exchange2.getResponse().bufferFactory();
        try {
            DefaultCallback callback = new DefaultCallback(info, handler, bufferFactory);
            new WebSocketProtocolHandshakeHandler(handshakes, (WebSocketConnectionCallback)callback).handleRequest(httpExchange);
        }
        catch (Exception ex) {
            return Mono.error(ex);
        }
        return Mono.empty();
    }

    private class DefaultCallback
    implements WebSocketConnectionCallback {
        private final HandshakeInfo handshakeInfo;
        private final WebSocketHandler handler;
        private final DataBufferFactory bufferFactory;

        public DefaultCallback(HandshakeInfo handshakeInfo, WebSocketHandler handler, DataBufferFactory bufferFactory) {
            this.handshakeInfo = handshakeInfo;
            this.handler = handler;
            this.bufferFactory = bufferFactory;
        }

        public void onConnect(WebSocketHttpExchange httpExchange, WebSocketChannel channel) {
            UndertowWebSocketSession session = this.createSession(channel);
            UndertowWebSocketHandlerAdapter adapter = new UndertowWebSocketHandlerAdapter(session);
            channel.getReceiveSetter().set((ChannelListener)adapter);
            channel.resumeReceives();
            this.handler.handle(session).subscribe(session);
        }

        private UndertowWebSocketSession createSession(WebSocketChannel channel) {
            return new UndertowWebSocketSession(channel, this.handshakeInfo, this.bufferFactory);
        }
    }
}

