/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;
import org.springframework.util.Assert;

class DefaultServerEndpointConfig
extends ServerEndpointConfig.Configurator
implements ServerEndpointConfig {
    private final String path;
    private final Endpoint endpoint;
    private List<String> protocols = new ArrayList<String>();

    public DefaultServerEndpointConfig(String path2, Endpoint endpoint) {
        Assert.hasText(path2, "path must not be empty");
        Assert.notNull((Object)endpoint, "endpoint must not be null");
        this.path = path2;
        this.endpoint = endpoint;
    }

    @Override
    public List<Class<? extends Encoder>> getEncoders() {
        return new ArrayList<Class<? extends Encoder>>();
    }

    @Override
    public List<Class<? extends Decoder>> getDecoders() {
        return new ArrayList<Class<? extends Decoder>>();
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return new HashMap<String, Object>();
    }

    @Override
    public Class<?> getEndpointClass() {
        return this.endpoint.getClass();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setSubprotocols(List<String> protocols) {
        this.protocols = protocols;
    }

    @Override
    public List<String> getSubprotocols() {
        return this.protocols;
    }

    @Override
    public List<Extension> getExtensions() {
        return new ArrayList<Extension>();
    }

    @Override
    public ServerEndpointConfig.Configurator getConfigurator() {
        return this;
    }

    @Override
    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        return (T)this.endpoint;
    }

    public String toString() {
        return "DefaultServerEndpointConfig for path '" + this.getPath() + "': " + this.getEndpointClass();
    }
}

