/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.ExceptionHandlerMethodResolver;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.SyncInvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.method.annotation.CookieValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ErrorsMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ExpressionValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.HttpEntityArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.MatrixVariableMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.MatrixVariableMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ModelArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ModelAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PathVariableMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PathVariableMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PrincipalArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestBodyArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestPartMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ServerWebExchangeArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.SessionAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.SessionAttributesHandler;
import org.springframework.web.reactive.result.method.annotation.SessionStatusMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.WebSessionArgumentResolver;

class ControllerMethodResolver {
    private static Log logger = LogFactory.getLog(ControllerMethodResolver.class);
    private final List<SyncHandlerMethodArgumentResolver> initBinderResolvers;
    private final List<HandlerMethodArgumentResolver> modelAttributeResolvers;
    private final List<HandlerMethodArgumentResolver> requestMappingResolvers;
    private final List<HandlerMethodArgumentResolver> exceptionHandlerResolvers;
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    private final Map<Class<?>, Set<Method>> initBinderMethodCache = new ConcurrentHashMap(64);
    private final Map<Class<?>, Set<Method>> modelAttributeMethodCache = new ConcurrentHashMap(64);
    private final Map<Class<?>, ExceptionHandlerMethodResolver> exceptionHandlerCache = new ConcurrentHashMap(64);
    private final Map<ControllerAdviceBean, Set<Method>> initBinderAdviceCache = new LinkedHashMap<ControllerAdviceBean, Set<Method>>(64);
    private final Map<ControllerAdviceBean, Set<Method>> modelAttributeAdviceCache = new LinkedHashMap<ControllerAdviceBean, Set<Method>>(64);
    private final Map<ControllerAdviceBean, ExceptionHandlerMethodResolver> exceptionHandlerAdviceCache = new LinkedHashMap<ControllerAdviceBean, ExceptionHandlerMethodResolver>(64);
    private final Map<Class<?>, SessionAttributesHandler> sessionAttributesHandlerCache = new ConcurrentHashMap(64);
    private static final ReflectionUtils.MethodFilter BINDER_METHODS = method2 -> AnnotationUtils.findAnnotation(method2, InitBinder.class) != null;
    private static final ReflectionUtils.MethodFilter ATTRIBUTE_METHODS = method2 -> AnnotationUtils.findAnnotation(method2, RequestMapping.class) == null && AnnotationUtils.findAnnotation(method2, ModelAttribute.class) != null;

    ControllerMethodResolver(ArgumentResolverConfigurer argumentResolvers, List<HttpMessageReader<?>> messageReaders, ReactiveAdapterRegistry reactiveRegistry, ConfigurableApplicationContext context) {
        Assert.notNull((Object)argumentResolvers, "ArgumentResolverConfigurer is required");
        Assert.notNull(messageReaders, "'messageReaders' is required");
        Assert.notNull((Object)reactiveRegistry, "ReactiveAdapterRegistry is required");
        Assert.notNull((Object)context, "ApplicationContext is required");
        ArgumentResolverRegistrar registrar = ArgumentResolverRegistrar.configurer(argumentResolvers).basic();
        this.addResolversTo(registrar, reactiveRegistry, context);
        this.initBinderResolvers = registrar.getSyncResolvers();
        registrar = ArgumentResolverRegistrar.configurer(argumentResolvers).modelAttributeSupport();
        this.addResolversTo(registrar, reactiveRegistry, context);
        this.modelAttributeResolvers = registrar.getResolvers();
        registrar = ArgumentResolverRegistrar.configurer(argumentResolvers).fullSupport(messageReaders);
        this.addResolversTo(registrar, reactiveRegistry, context);
        this.requestMappingResolvers = registrar.getResolvers();
        registrar = ArgumentResolverRegistrar.configurer(argumentResolvers).basic();
        this.addResolversTo(registrar, reactiveRegistry, context);
        this.exceptionHandlerResolvers = registrar.getResolvers();
        this.reactiveAdapterRegistry = reactiveRegistry;
        this.initControllerAdviceCaches(context);
    }

    private void addResolversTo(ArgumentResolverRegistrar registrar, ReactiveAdapterRegistry reactiveRegistry, ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        registrar.add(new RequestParamMethodArgumentResolver(beanFactory, reactiveRegistry, false));
        registrar.add(new RequestParamMapMethodArgumentResolver(reactiveRegistry));
        registrar.add(new PathVariableMethodArgumentResolver(beanFactory, reactiveRegistry));
        registrar.add(new PathVariableMapMethodArgumentResolver(reactiveRegistry));
        registrar.add(new MatrixVariableMethodArgumentResolver(beanFactory, reactiveRegistry));
        registrar.add(new MatrixVariableMapMethodArgumentResolver(reactiveRegistry));
        registrar.addIfRequestBody(readers -> new RequestBodyArgumentResolver((List<HttpMessageReader<?>>)readers, reactiveRegistry));
        registrar.addIfRequestBody(readers -> new RequestPartMethodArgumentResolver((List<HttpMessageReader<?>>)readers, reactiveRegistry));
        registrar.addIfModelAttribute(() -> new ModelAttributeMethodArgumentResolver(reactiveRegistry, false));
        registrar.add(new RequestHeaderMethodArgumentResolver(beanFactory, reactiveRegistry));
        registrar.add(new RequestHeaderMapMethodArgumentResolver(reactiveRegistry));
        registrar.add(new CookieValueMethodArgumentResolver(beanFactory, reactiveRegistry));
        registrar.add(new ExpressionValueMethodArgumentResolver(beanFactory, reactiveRegistry));
        registrar.add(new SessionAttributeMethodArgumentResolver(beanFactory, reactiveRegistry));
        registrar.add(new RequestAttributeMethodArgumentResolver(beanFactory, reactiveRegistry));
        registrar.addIfRequestBody(readers -> new HttpEntityArgumentResolver((List<HttpMessageReader<?>>)readers, reactiveRegistry));
        registrar.add(new ModelArgumentResolver(reactiveRegistry));
        registrar.addIfModelAttribute(() -> new ErrorsMethodArgumentResolver(reactiveRegistry));
        registrar.add(new ServerWebExchangeArgumentResolver(reactiveRegistry));
        registrar.add(new PrincipalArgumentResolver(reactiveRegistry));
        registrar.addIfRequestBody(readers -> new SessionStatusMethodArgumentResolver());
        registrar.add(new WebSessionArgumentResolver(reactiveRegistry));
        registrar.addCustomResolvers();
        registrar.add(new RequestParamMethodArgumentResolver(beanFactory, reactiveRegistry, true));
        registrar.addIfModelAttribute(() -> new ModelAttributeMethodArgumentResolver(reactiveRegistry, true));
    }

    private void initControllerAdviceCaches(@Nullable ApplicationContext applicationContext) {
        if (applicationContext == null) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Looking for @ControllerAdvice: " + applicationContext);
        }
        List<ControllerAdviceBean> beans2 = ControllerAdviceBean.findAnnotatedBeans(applicationContext);
        AnnotationAwareOrderComparator.sort(beans2);
        for (ControllerAdviceBean bean2 : beans2) {
            ExceptionHandlerMethodResolver resolver;
            Set<Method> binderMethods;
            Class<?> beanType = bean2.getBeanType();
            if (beanType == null) continue;
            Set<Method> attrMethods = MethodIntrospector.selectMethods(beanType, ATTRIBUTE_METHODS);
            if (!attrMethods.isEmpty()) {
                this.modelAttributeAdviceCache.put(bean2, attrMethods);
                if (logger.isInfoEnabled()) {
                    logger.info("Detected @ModelAttribute methods in " + bean2);
                }
            }
            if (!(binderMethods = MethodIntrospector.selectMethods(beanType, BINDER_METHODS)).isEmpty()) {
                this.initBinderAdviceCache.put(bean2, binderMethods);
                if (logger.isInfoEnabled()) {
                    logger.info("Detected @InitBinder methods in " + bean2);
                }
            }
            if (!(resolver = new ExceptionHandlerMethodResolver(beanType)).hasExceptionMappings()) continue;
            this.exceptionHandlerAdviceCache.put(bean2, resolver);
            if (!logger.isInfoEnabled()) continue;
            logger.info("Detected @ExceptionHandler methods in " + bean2);
        }
    }

    public InvocableHandlerMethod getRequestMappingMethod(HandlerMethod handlerMethod) {
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(handlerMethod);
        invocable.setArgumentResolvers(this.requestMappingResolvers);
        invocable.setReactiveAdapterRegistry(this.reactiveAdapterRegistry);
        return invocable;
    }

    public List<SyncInvocableHandlerMethod> getInitBinderMethods(HandlerMethod handlerMethod) {
        ArrayList<SyncInvocableHandlerMethod> result = new ArrayList<SyncInvocableHandlerMethod>();
        Class<?> handlerType = handlerMethod.getBeanType();
        this.initBinderAdviceCache.forEach((adviceBean, methods) -> {
            if (adviceBean.isApplicableToBeanType(handlerType)) {
                Object bean2 = adviceBean.resolveBean();
                methods.forEach(method2 -> result.add(this.getInitBinderMethod(bean2, (Method)method2)));
            }
        });
        this.initBinderMethodCache.computeIfAbsent(handlerType, aClass -> MethodIntrospector.selectMethods(handlerType, BINDER_METHODS)).forEach(method2 -> {
            Object bean2 = handlerMethod.getBean();
            result.add(this.getInitBinderMethod(bean2, (Method)method2));
        });
        return result;
    }

    private SyncInvocableHandlerMethod getInitBinderMethod(Object bean2, Method method2) {
        SyncInvocableHandlerMethod invocable = new SyncInvocableHandlerMethod(bean2, method2);
        invocable.setArgumentResolvers(this.initBinderResolvers);
        return invocable;
    }

    public List<InvocableHandlerMethod> getModelAttributeMethods(HandlerMethod handlerMethod) {
        ArrayList<InvocableHandlerMethod> result = new ArrayList<InvocableHandlerMethod>();
        Class<?> handlerType = handlerMethod.getBeanType();
        this.modelAttributeAdviceCache.forEach((adviceBean, methods) -> {
            if (adviceBean.isApplicableToBeanType(handlerType)) {
                Object bean2 = adviceBean.resolveBean();
                methods.forEach(method2 -> result.add(this.createAttributeMethod(bean2, (Method)method2)));
            }
        });
        this.modelAttributeMethodCache.computeIfAbsent(handlerType, aClass -> MethodIntrospector.selectMethods(handlerType, ATTRIBUTE_METHODS)).forEach(method2 -> {
            Object bean2 = handlerMethod.getBean();
            result.add(this.createAttributeMethod(bean2, (Method)method2));
        });
        return result;
    }

    private InvocableHandlerMethod createAttributeMethod(Object bean2, Method method2) {
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(bean2, method2);
        invocable.setArgumentResolvers(this.modelAttributeResolvers);
        return invocable;
    }

    @Nullable
    public InvocableHandlerMethod getExceptionHandlerMethod(Throwable ex, HandlerMethod handlerMethod) {
        Class<?> handlerType = handlerMethod.getBeanType();
        Object targetBean = handlerMethod.getBean();
        Method targetMethod = this.exceptionHandlerCache.computeIfAbsent(handlerType, ExceptionHandlerMethodResolver::new).resolveMethodByThrowable(ex);
        if (targetMethod == null) {
            for (ControllerAdviceBean advice : this.exceptionHandlerAdviceCache.keySet()) {
                if (!advice.isApplicableToBeanType(handlerType)) continue;
                targetBean = advice.resolveBean();
                targetMethod = this.exceptionHandlerAdviceCache.get(advice).resolveMethodByThrowable(ex);
                if (targetMethod == null) continue;
                break;
            }
        }
        if (targetMethod == null) {
            return null;
        }
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(targetBean, targetMethod);
        invocable.setArgumentResolvers(this.exceptionHandlerResolvers);
        return invocable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionAttributesHandler getSessionAttributesHandler(HandlerMethod handlerMethod) {
        Class<?> handlerType = handlerMethod.getBeanType();
        SessionAttributesHandler result = this.sessionAttributesHandlerCache.get(handlerType);
        if (result == null) {
            Map<Class<?>, SessionAttributesHandler> map = this.sessionAttributesHandlerCache;
            synchronized (map) {
                result = this.sessionAttributesHandlerCache.get(handlerType);
                if (result == null) {
                    result = new SessionAttributesHandler(handlerType);
                    this.sessionAttributesHandlerCache.put(handlerType, result);
                }
            }
        }
        return result;
    }

    private static class ArgumentResolverRegistrar {
        private final List<HandlerMethodArgumentResolver> customResolvers;
        private final List<HttpMessageReader<?>> messageReaders;
        private final boolean modelAttributeSupported;
        private final List<HandlerMethodArgumentResolver> result = new ArrayList<HandlerMethodArgumentResolver>();

        private ArgumentResolverRegistrar(ArgumentResolverConfigurer resolvers, List<HttpMessageReader<?>> messageReaders, boolean modelAttribute) {
            this.customResolvers = resolvers.getCustomResolvers();
            this.messageReaders = messageReaders;
            this.modelAttributeSupported = modelAttribute;
        }

        public void add(HandlerMethodArgumentResolver resolver) {
            this.result.add(resolver);
        }

        public void addIfRequestBody(Function<List<HttpMessageReader<?>>, HandlerMethodArgumentResolver> function) {
            if (!CollectionUtils.isEmpty(this.messageReaders)) {
                this.add(function.apply(this.messageReaders));
            }
        }

        public void addIfModelAttribute(Supplier<HandlerMethodArgumentResolver> supplier) {
            if (this.modelAttributeSupported) {
                this.add(supplier.get());
            }
        }

        public void addCustomResolvers() {
            this.customResolvers.forEach(this::add);
        }

        public List<HandlerMethodArgumentResolver> getResolvers() {
            return this.result;
        }

        public List<SyncHandlerMethodArgumentResolver> getSyncResolvers() {
            return this.result.stream().filter(resolver -> resolver instanceof SyncHandlerMethodArgumentResolver).map(resolver -> (SyncHandlerMethodArgumentResolver)resolver).collect(Collectors.toList());
        }

        public static Builder configurer(ArgumentResolverConfigurer configurer) {
            return new Builder(configurer);
        }

        public static class Builder {
            private final ArgumentResolverConfigurer resolvers;

            public Builder(ArgumentResolverConfigurer configurer) {
                this.resolvers = configurer;
            }

            public ArgumentResolverRegistrar fullSupport(List<HttpMessageReader<?>> httpMessageReaders) {
                return new ArgumentResolverRegistrar(this.resolvers, httpMessageReaders, true);
            }

            public ArgumentResolverRegistrar modelAttributeSupport() {
                return new ArgumentResolverRegistrar(this.resolvers, Collections.emptyList(), true);
            }

            public ArgumentResolverRegistrar basic() {
                return new ArgumentResolverRegistrar(this.resolvers, Collections.emptyList(), false);
            }
        }
    }
}

