/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class RequestPredicates {
    private static final Log logger = LogFactory.getLog(RequestPredicates.class);
    private static final PathPatternParser DEFAULT_PATTERN_PARSER = new PathPatternParser();

    public static RequestPredicate all() {
        return request -> true;
    }

    public static RequestPredicate method(HttpMethod httpMethod) {
        return new HttpMethodPredicate(httpMethod);
    }

    public static RequestPredicate path(String pattern) {
        Assert.notNull((Object)pattern, "'pattern' must not be null");
        return RequestPredicates.pathPredicates(DEFAULT_PATTERN_PARSER).apply(pattern);
    }

    public static Function<String, RequestPredicate> pathPredicates(PathPatternParser patternParser) {
        Assert.notNull((Object)patternParser, "'patternParser' must not be null");
        return pattern -> new PathPatternPredicate(patternParser.parse((String)pattern));
    }

    public static RequestPredicate headers(Predicate<ServerRequest.Headers> headersPredicate) {
        return new HeadersPredicate(headersPredicate);
    }

    public static RequestPredicate contentType(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, "'mediaTypes' must not be empty");
        final HashSet<MediaType> mediaTypeSet = new HashSet<MediaType>(Arrays.asList(mediaTypes));
        return RequestPredicates.headers(new Predicate<ServerRequest.Headers>(){

            @Override
            public boolean test(ServerRequest.Headers headers2) {
                MediaType contentType2 = headers2.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
                boolean match = mediaTypeSet.stream().anyMatch(mediaType -> mediaType.includes(contentType2));
                RequestPredicates.traceMatch("Content-Type", mediaTypeSet, contentType2, match);
                return match;
            }

            public String toString() {
                return String.format("Content-Type: %s", mediaTypeSet);
            }
        });
    }

    public static RequestPredicate accept(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, "'mediaTypes' must not be empty");
        final HashSet<MediaType> mediaTypeSet = new HashSet<MediaType>(Arrays.asList(mediaTypes));
        return RequestPredicates.headers(new Predicate<ServerRequest.Headers>(){

            @Override
            public boolean test(ServerRequest.Headers headers2) {
                List<MediaType> acceptedMediaTypes = headers2.accept();
                if (acceptedMediaTypes.isEmpty()) {
                    acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
                } else {
                    MediaType.sortBySpecificityAndQuality(acceptedMediaTypes);
                }
                boolean match = acceptedMediaTypes.stream().anyMatch(acceptedMediaType -> mediaTypeSet.stream().anyMatch(acceptedMediaType::isCompatibleWith));
                RequestPredicates.traceMatch("Accept", mediaTypeSet, acceptedMediaTypes, match);
                return match;
            }

            public String toString() {
                return String.format("Accept: %s", mediaTypeSet);
            }
        });
    }

    public static RequestPredicate GET(String pattern) {
        return RequestPredicates.method(HttpMethod.GET).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate HEAD(String pattern) {
        return RequestPredicates.method(HttpMethod.HEAD).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate POST(String pattern) {
        return RequestPredicates.method(HttpMethod.POST).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate PUT(String pattern) {
        return RequestPredicates.method(HttpMethod.PUT).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate PATCH(String pattern) {
        return RequestPredicates.method(HttpMethod.PATCH).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate DELETE(String pattern) {
        return RequestPredicates.method(HttpMethod.DELETE).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate OPTIONS(String pattern) {
        return RequestPredicates.method(HttpMethod.OPTIONS).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate pathExtension(String extension) {
        Assert.notNull((Object)extension, "'extension' must not be null");
        return RequestPredicates.pathExtension((String pathExtension2) -> {
            boolean match = extension.equalsIgnoreCase((String)pathExtension2);
            RequestPredicates.traceMatch("Extension", extension, pathExtension2, match);
            return match;
        });
    }

    public static RequestPredicate pathExtension(Predicate<String> extensionPredicate) {
        Assert.notNull(extensionPredicate, "'extensionPredicate' must not be null");
        return request -> {
            String pathExtension2 = UriUtils.extractFileExtension(request.path());
            return extensionPredicate.test(pathExtension2);
        };
    }

    public static RequestPredicate queryParam(String name, Predicate<String> predicate) {
        return request -> {
            Optional<String> s2 = request.queryParam(name);
            return s2.filter(predicate).isPresent();
        };
    }

    private static void traceMatch(String prefix, Object desired, @Nullable Object actual, boolean match) {
        if (logger.isTraceEnabled()) {
            String message = String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match ? "matches" : "does not match", actual);
            logger.trace(message);
        }
    }

    private static class SubPathServerRequestWrapper
    implements ServerRequest {
        private final ServerRequest request;
        private final PathContainer subPathContainer;
        private final Map<String, String> pathVariables;

        public SubPathServerRequestWrapper(ServerRequest request, PathPattern.PathRemainingMatchInfo info) {
            this.request = request;
            this.subPathContainer = new SubPathContainer(info.getPathRemaining());
            this.pathVariables = SubPathServerRequestWrapper.mergePathVariables(request, info.getUriVariables());
        }

        private static Map<String, String> mergePathVariables(ServerRequest request, Map<String, String> pathVariables) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(request.pathVariables());
            result.putAll(pathVariables);
            return Collections.unmodifiableMap(result);
        }

        @Override
        public HttpMethod method() {
            return this.request.method();
        }

        @Override
        public String methodName() {
            return this.request.methodName();
        }

        @Override
        public URI uri() {
            return this.request.uri();
        }

        @Override
        public UriBuilder uriBuilder() {
            return this.request.uriBuilder();
        }

        @Override
        public String path() {
            return this.subPathContainer.value();
        }

        @Override
        public PathContainer pathContainer() {
            return this.subPathContainer;
        }

        @Override
        public ServerRequest.Headers headers() {
            return this.request.headers();
        }

        @Override
        public MultiValueMap<String, HttpCookie> cookies() {
            return this.request.cookies();
        }

        @Override
        public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor) {
            return this.request.body(extractor);
        }

        @Override
        public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor, Map<String, Object> hints) {
            return this.request.body(extractor, hints);
        }

        @Override
        public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
            return this.request.bodyToMono(elementClass);
        }

        @Override
        public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> typeReference) {
            return this.request.bodyToMono(typeReference);
        }

        @Override
        public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
            return this.request.bodyToFlux(elementClass);
        }

        @Override
        public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> typeReference) {
            return this.request.bodyToFlux(typeReference);
        }

        @Override
        public Optional<Object> attribute(String name) {
            return this.request.attribute(name);
        }

        @Override
        public Map<String, Object> attributes() {
            return this.request.attributes();
        }

        @Override
        public Optional<String> queryParam(String name) {
            return this.request.queryParam(name);
        }

        @Override
        public MultiValueMap<String, String> queryParams() {
            return this.request.queryParams();
        }

        @Override
        public Map<String, String> pathVariables() {
            return this.pathVariables;
        }

        @Override
        public Mono<WebSession> session() {
            return this.request.session();
        }

        @Override
        public Mono<? extends Principal> principal() {
            return this.request.principal();
        }

        @Override
        public Mono<MultiValueMap<String, String>> formData() {
            return this.request.formData();
        }

        @Override
        public Mono<MultiValueMap<String, Part>> multipartData() {
            return this.request.multipartData();
        }

        public String toString() {
            return (Object)((Object)this.method()) + " " + this.path();
        }

        private static class SubPathContainer
        implements PathContainer {
            private static final PathContainer.Separator SEPARATOR = () -> "/";
            private final String value;
            private final List<PathContainer.Element> elements;

            public SubPathContainer(PathContainer original) {
                this.value = SubPathContainer.prefixWithSlash(original.value());
                this.elements = SubPathContainer.prependWithSeparator(original.elements());
            }

            private static String prefixWithSlash(String path2) {
                if (!path2.startsWith("/")) {
                    path2 = "/" + path2;
                }
                return path2;
            }

            private static List<PathContainer.Element> prependWithSeparator(List<PathContainer.Element> elements) {
                ArrayList<PathContainer.Element> result = new ArrayList<PathContainer.Element>(elements);
                if (result.isEmpty() || !(result.get(0) instanceof PathContainer.Separator)) {
                    result.add(0, SEPARATOR);
                }
                return Collections.unmodifiableList(result);
            }

            @Override
            public String value() {
                return this.value;
            }

            @Override
            public List<PathContainer.Element> elements() {
                return this.elements;
            }
        }
    }

    static class OrRequestPredicate
    implements RequestPredicate {
        private final RequestPredicate left;
        private final RequestPredicate right;

        public OrRequestPredicate(RequestPredicate left, RequestPredicate right) {
            Assert.notNull((Object)left, "Left RequestPredicate must not be null");
            Assert.notNull((Object)right, "Right RequestPredicate must not be null");
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean test(ServerRequest t) {
            return this.left.test(t) || this.right.test(t);
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            Optional<ServerRequest> leftResult = this.left.nest(request);
            if (leftResult.isPresent()) {
                return leftResult;
            }
            return this.right.nest(request);
        }

        public String toString() {
            return String.format("(%s || %s)", this.left, this.right);
        }
    }

    static class AndRequestPredicate
    implements RequestPredicate {
        private final RequestPredicate left;
        private final RequestPredicate right;

        public AndRequestPredicate(RequestPredicate left, RequestPredicate right) {
            Assert.notNull((Object)left, "Left RequestPredicate must not be null");
            Assert.notNull((Object)right, "Right RequestPredicate must not be null");
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean test(ServerRequest t) {
            return this.left.test(t) && this.right.test(t);
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            return this.left.nest(request).flatMap(this.right::nest);
        }

        public String toString() {
            return String.format("(%s && %s)", this.left, this.right);
        }
    }

    private static class HeadersPredicate
    implements RequestPredicate {
        private final Predicate<ServerRequest.Headers> headersPredicate;

        public HeadersPredicate(Predicate<ServerRequest.Headers> headersPredicate) {
            Assert.notNull(headersPredicate, "Predicate must not be null");
            this.headersPredicate = headersPredicate;
        }

        @Override
        public boolean test(ServerRequest request) {
            return this.headersPredicate.test(request.headers());
        }

        public String toString() {
            return this.headersPredicate.toString();
        }
    }

    private static class PathPatternPredicate
    implements RequestPredicate {
        private final PathPattern pattern;

        public PathPatternPredicate(PathPattern pattern) {
            Assert.notNull((Object)pattern, "'pattern' must not be null");
            this.pattern = pattern;
        }

        @Override
        public boolean test(ServerRequest request) {
            PathContainer pathContainer = request.pathContainer();
            PathPattern.PathMatchInfo info = this.pattern.matchAndExtract(pathContainer);
            RequestPredicates.traceMatch("Pattern", this.pattern.getPatternString(), request.path(), info != null);
            if (info != null) {
                this.mergeTemplateVariables(request, info.getUriVariables());
                return true;
            }
            return false;
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            return Optional.ofNullable(this.pattern.matchStartOfPath(request.pathContainer())).map(info -> new SubPathServerRequestWrapper(request, (PathPattern.PathRemainingMatchInfo)info));
        }

        private void mergeTemplateVariables(ServerRequest request, Map<String, String> variables) {
            if (!variables.isEmpty()) {
                Map<String, String> oldVariables = request.pathVariables();
                LinkedHashMap<String, String> mergedVariables = new LinkedHashMap<String, String>(oldVariables);
                mergedVariables.putAll(variables);
                request.attributes().put(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.unmodifiableMap(mergedVariables));
            }
        }

        public String toString() {
            return this.pattern.getPatternString();
        }
    }

    private static class HttpMethodPredicate
    implements RequestPredicate {
        private final HttpMethod httpMethod;

        public HttpMethodPredicate(HttpMethod httpMethod) {
            Assert.notNull((Object)httpMethod, "HttpMethod must not be null");
            this.httpMethod = httpMethod;
        }

        @Override
        public boolean test(ServerRequest request) {
            boolean match = this.httpMethod == request.method();
            RequestPredicates.traceMatch("Method", (Object)this.httpMethod, (Object)request.method(), match);
            return match;
        }

        public String toString() {
            return this.httpMethod.toString();
        }
    }
}

