/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import reactor.core.publisher.Mono;

public abstract class ExchangeFilterFunctions {
    public static final String BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE = ExchangeFilterFunctions.class.getName() + ".basicAuthenticationCredentials";

    public static ExchangeFilterFunction basicAuthentication(String username, String password) {
        Assert.notNull((Object)username, "'username' must not be null");
        Assert.notNull((Object)password, "'password' must not be null");
        ExchangeFilterFunctions.checkIllegalCharacters(username, password);
        return ExchangeFilterFunctions.basicAuthenticationInternal(r -> Optional.of(new Credentials(username, password)));
    }

    public static ExchangeFilterFunction basicAuthentication() {
        return ExchangeFilterFunctions.basicAuthenticationInternal(request -> request.attribute(BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE).map(o -> (Credentials)o));
    }

    private static ExchangeFilterFunction basicAuthenticationInternal(Function<ClientRequest, Optional<Credentials>> credentialsFunction) {
        return ExchangeFilterFunction.ofRequestProcessor(clientRequest -> ((Optional)credentialsFunction.apply((ClientRequest)clientRequest)).map(credentials -> {
            ClientRequest authorizedRequest = ClientRequest.from(clientRequest).headers(headers2 -> headers2.set("Authorization", ExchangeFilterFunctions.authorization(credentials))).build();
            return Mono.just(authorizedRequest);
        }).orElse(Mono.just(clientRequest)));
    }

    private static String authorization(Credentials credentials) {
        String credentialsString = credentials.username + ":" + credentials.password;
        byte[] credentialBytes = credentialsString.getBytes(StandardCharsets.ISO_8859_1);
        byte[] encodedBytes = Base64.getEncoder().encode(credentialBytes);
        String encodedCredentials = new String(encodedBytes, StandardCharsets.ISO_8859_1);
        return "Basic " + encodedCredentials;
    }

    private static void checkIllegalCharacters(String username, String password) {
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        if (!encoder.canEncode(username) || !encoder.canEncode(password)) {
            throw new IllegalArgumentException("Username or password contains characters that cannot be encoded to ISO-8859-1");
        }
    }

    public static ExchangeFilterFunction statusError(Predicate<HttpStatus> statusPredicate, Function<ClientResponse, ? extends Throwable> exceptionFunction) {
        Assert.notNull(statusPredicate, "Predicate must not be null");
        Assert.notNull(exceptionFunction, "Function must not be null");
        return ExchangeFilterFunction.ofResponseProcessor(clientResponse -> {
            if (statusPredicate.test(clientResponse.statusCode())) {
                return Mono.error((Throwable)exceptionFunction.apply((ClientResponse)clientResponse));
            }
            return Mono.just(clientResponse);
        });
    }

    public static final class Credentials {
        private final String username;
        private final String password;

        public Credentials(String username, String password) {
            Assert.notNull((Object)username, "'username' must not be null");
            Assert.notNull((Object)password, "'password' must not be null");
            this.username = username;
            this.password = password;
        }

        public static Consumer<Map<String, Object>> basicAuthenticationCredentials(String username, String password) {
            Credentials credentials = new Credentials(username, password);
            ExchangeFilterFunctions.checkIllegalCharacters(username, password);
            return attributes -> attributes.put(BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE, credentials);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Credentials) {
                Credentials other = (Credentials)o;
                return this.username.equals(other.username) && this.password.equals(other.password);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.username.hashCode() + this.password.hashCode();
        }
    }
}

