/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class BodyExtractors {
    private static final ResolvableType FORM_MAP_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, String.class, String.class);
    private static final ResolvableType MULTIPART_MAP_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, String.class, Part.class);
    private static final ResolvableType PART_TYPE = ResolvableType.forClass(Part.class);
    private static final ResolvableType VOID_TYPE = ResolvableType.forClass(Void.class);

    public static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(Class<? extends T> elementClass) {
        return BodyExtractors.toMono(ResolvableType.forClass(elementClass));
    }

    public static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(ParameterizedTypeReference<T> typeReference) {
        return BodyExtractors.toMono(ResolvableType.forType(typeReference.getType()));
    }

    static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(ResolvableType elementType) {
        return (inputMessage, context) -> BodyExtractors.readWithMessageReaders(inputMessage, context, elementType, reader -> {
            Optional<ServerHttpResponse> serverResponse = context.serverResponse();
            if (serverResponse.isPresent() && inputMessage instanceof ServerHttpRequest) {
                return reader.readMono(elementType, elementType, (ServerHttpRequest)inputMessage, serverResponse.get(), context.hints());
            }
            return reader.readMono(elementType, inputMessage, context.hints());
        }, ex -> inputMessage.getHeaders().getContentType() == null ? Mono.from(BodyExtractors.permitEmptyOrFail(inputMessage, ex)) : Mono.error(ex), Mono::empty);
    }

    public static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(Class<? extends T> elementClass) {
        return BodyExtractors.toFlux(ResolvableType.forClass(elementClass));
    }

    public static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(ParameterizedTypeReference<T> typeReference) {
        return BodyExtractors.toFlux(ResolvableType.forType(typeReference.getType()));
    }

    static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(ResolvableType elementType) {
        return (inputMessage, context) -> BodyExtractors.readWithMessageReaders(inputMessage, context, elementType, reader -> {
            Optional<ServerHttpResponse> serverResponse = context.serverResponse();
            if (serverResponse.isPresent() && inputMessage instanceof ServerHttpRequest) {
                return reader.read(elementType, elementType, (ServerHttpRequest)inputMessage, serverResponse.get(), context.hints());
            }
            return reader.read(elementType, inputMessage, context.hints());
        }, ex -> inputMessage.getHeaders().getContentType() == null ? BodyExtractors.permitEmptyOrFail(inputMessage, ex) : Flux.error(ex), Flux::empty);
    }

    private static <T> Flux<T> permitEmptyOrFail(ReactiveHttpInputMessage message, UnsupportedMediaTypeException ex) {
        return message.getBody().doOnNext(buffer -> {
            throw ex;
        }).map(o -> o);
    }

    public static BodyExtractor<Mono<MultiValueMap<String, String>>, ServerHttpRequest> toFormData() {
        return (request, context) -> {
            ResolvableType type = FORM_MAP_TYPE;
            HttpMessageReader reader = BodyExtractors.messageReader(type, MediaType.APPLICATION_FORM_URLENCODED, context);
            return context.serverResponse().map(response -> reader.readMono(type, type, (ServerHttpRequest)request, (ServerHttpResponse)response, context.hints())).orElseGet(() -> reader.readMono(type, request, context.hints()));
        };
    }

    public static BodyExtractor<Mono<MultiValueMap<String, Part>>, ServerHttpRequest> toMultipartData() {
        return (serverRequest, context) -> {
            ResolvableType type = MULTIPART_MAP_TYPE;
            HttpMessageReader reader = BodyExtractors.messageReader(type, MediaType.MULTIPART_FORM_DATA, context);
            return context.serverResponse().map(response -> reader.readMono(type, type, (ServerHttpRequest)serverRequest, (ServerHttpResponse)response, context.hints())).orElseGet(() -> reader.readMono(type, serverRequest, context.hints()));
        };
    }

    public static BodyExtractor<Flux<Part>, ServerHttpRequest> toParts() {
        return (serverRequest, context) -> {
            ResolvableType type = PART_TYPE;
            HttpMessageReader reader = BodyExtractors.messageReader(type, MediaType.MULTIPART_FORM_DATA, context);
            return context.serverResponse().map(response -> reader.read(type, type, (ServerHttpRequest)serverRequest, (ServerHttpResponse)response, context.hints())).orElseGet(() -> reader.read(type, serverRequest, context.hints()));
        };
    }

    public static BodyExtractor<Flux<DataBuffer>, ReactiveHttpInputMessage> toDataBuffers() {
        return (inputMessage, context) -> inputMessage.getBody();
    }

    private static <T, S extends Publisher<T>> S readWithMessageReaders(ReactiveHttpInputMessage inputMessage, BodyExtractor.Context context, ResolvableType elementType, Function<HttpMessageReader<T>, S> readerFunction, Function<UnsupportedMediaTypeException, S> unsupportedError, Supplier<S> empty) {
        if (VOID_TYPE.equals(elementType)) {
            return (S)((Publisher)empty.get());
        }
        MediaType contentType2 = BodyExtractors.contentType(inputMessage);
        List<HttpMessageReader<?>> messageReaders = context.messageReaders();
        return (S)messageReaders.stream().filter(r -> r.canRead(elementType, contentType2)).findFirst().map(BodyExtractors::cast).map(readerFunction).orElseGet(() -> {
            List<MediaType> supportedMediaTypes = messageReaders.stream().flatMap(reader -> reader.getReadableMediaTypes().stream()).collect(Collectors.toList());
            UnsupportedMediaTypeException error = new UnsupportedMediaTypeException(contentType2, supportedMediaTypes);
            return (Publisher)unsupportedError.apply(error);
        });
    }

    private static <T> HttpMessageReader<T> messageReader(ResolvableType elementType, MediaType mediaType, BodyExtractor.Context context) {
        return context.messageReaders().stream().filter(messageReader -> messageReader.canRead(elementType, mediaType)).findFirst().map(BodyExtractors::cast).orElseThrow(() -> new IllegalStateException("Could not find HttpMessageReader that supports \"" + mediaType + "\" and \"" + elementType + "\""));
    }

    private static MediaType contentType(HttpMessage message) {
        MediaType result = message.getHeaders().getContentType();
        return result != null ? result : MediaType.APPLICATION_OCTET_STREAM;
    }

    private static <T> HttpMessageReader<T> cast(HttpMessageReader<?> messageReader) {
        return messageReader;
    }
}

