/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import org.springframework.http.HttpStatus;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;

public class StatusAssertions {
    private final ExchangeResult exchangeResult;
    private final WebTestClient.ResponseSpec responseSpec;

    StatusAssertions(ExchangeResult result, WebTestClient.ResponseSpec spec) {
        this.exchangeResult = result;
        this.responseSpec = spec;
    }

    public WebTestClient.ResponseSpec isEqualTo(HttpStatus status) {
        return this.isEqualTo(status.value());
    }

    public WebTestClient.ResponseSpec isEqualTo(int status) {
        int actual = this.exchangeResult.getStatus().value();
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Status", status, actual));
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec isOk() {
        return this.assertStatusAndReturn(HttpStatus.OK);
    }

    public WebTestClient.ResponseSpec isCreated() {
        HttpStatus expected = HttpStatus.CREATED;
        return this.assertStatusAndReturn(expected);
    }

    public WebTestClient.ResponseSpec isAccepted() {
        return this.assertStatusAndReturn(HttpStatus.ACCEPTED);
    }

    public WebTestClient.ResponseSpec isNoContent() {
        return this.assertStatusAndReturn(HttpStatus.NO_CONTENT);
    }

    public WebTestClient.ResponseSpec isFound() {
        return this.assertStatusAndReturn(HttpStatus.FOUND);
    }

    public WebTestClient.ResponseSpec isSeeOther() {
        return this.assertStatusAndReturn(HttpStatus.SEE_OTHER);
    }

    public WebTestClient.ResponseSpec isNotModified() {
        return this.assertStatusAndReturn(HttpStatus.NOT_MODIFIED);
    }

    public WebTestClient.ResponseSpec isTemporaryRedirect() {
        return this.assertStatusAndReturn(HttpStatus.TEMPORARY_REDIRECT);
    }

    public WebTestClient.ResponseSpec isPermanentRedirect() {
        return this.assertStatusAndReturn(HttpStatus.PERMANENT_REDIRECT);
    }

    public WebTestClient.ResponseSpec isBadRequest() {
        return this.assertStatusAndReturn(HttpStatus.BAD_REQUEST);
    }

    public WebTestClient.ResponseSpec isUnauthorized() {
        return this.assertStatusAndReturn(HttpStatus.UNAUTHORIZED);
    }

    public WebTestClient.ResponseSpec isForbidden() {
        return this.assertStatusAndReturn(HttpStatus.FORBIDDEN);
    }

    public WebTestClient.ResponseSpec isNotFound() {
        return this.assertStatusAndReturn(HttpStatus.NOT_FOUND);
    }

    public WebTestClient.ResponseSpec reasonEquals(String reason) {
        String actual = this.exchangeResult.getStatus().getReasonPhrase();
        String message = "Response status reason";
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertEquals(message, reason, actual));
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec is1xxInformational() {
        return this.assertSeriesAndReturn(HttpStatus.Series.INFORMATIONAL);
    }

    public WebTestClient.ResponseSpec is2xxSuccessful() {
        return this.assertSeriesAndReturn(HttpStatus.Series.SUCCESSFUL);
    }

    public WebTestClient.ResponseSpec is3xxRedirection() {
        return this.assertSeriesAndReturn(HttpStatus.Series.REDIRECTION);
    }

    public WebTestClient.ResponseSpec is4xxClientError() {
        return this.assertSeriesAndReturn(HttpStatus.Series.CLIENT_ERROR);
    }

    public WebTestClient.ResponseSpec is5xxServerError() {
        HttpStatus.Series expected = HttpStatus.Series.SERVER_ERROR;
        return this.assertSeriesAndReturn(expected);
    }

    private WebTestClient.ResponseSpec assertStatusAndReturn(HttpStatus expected) {
        HttpStatus actual = this.exchangeResult.getStatus();
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Status", (Object)expected, (Object)actual));
        return this.responseSpec;
    }

    private WebTestClient.ResponseSpec assertSeriesAndReturn(HttpStatus.Series expected) {
        HttpStatus status = this.exchangeResult.getStatus();
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Range for response status value " + (Object)((Object)status), (Object)expected, (Object)status.series()));
        return this.responseSpec;
    }
}

