/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.test.util.AopTestUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class ReflectionTestUtils {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final Log logger = LogFactory.getLog(ReflectionTestUtils.class);
    private static final boolean springAopPresent = ClassUtils.isPresent("org.springframework.aop.framework.Advised", ReflectionTestUtils.class.getClassLoader());

    public static void setField(Object targetObject, String name, @Nullable Object value) {
        ReflectionTestUtils.setField(targetObject, name, value, null);
    }

    public static void setField(Object targetObject, @Nullable String name, @Nullable Object value, @Nullable Class<?> type) {
        ReflectionTestUtils.setField(targetObject, null, name, value, type);
    }

    public static void setField(Class<?> targetClass, String name, @Nullable Object value) {
        ReflectionTestUtils.setField(null, targetClass, name, value, null);
    }

    public static void setField(Class<?> targetClass, @Nullable String name, @Nullable Object value, @Nullable Class<?> type) {
        ReflectionTestUtils.setField(null, targetClass, name, value, type);
    }

    public static void setField(@Nullable Object targetObject, @Nullable Class<?> targetClass, @Nullable String name, @Nullable Object value, @Nullable Class<?> type) {
        Field field;
        Assert.isTrue(targetObject != null || targetClass != null, "Either targetObject or targetClass for the field must be specified");
        if (targetObject != null && springAopPresent) {
            targetObject = AopTestUtils.getUltimateTargetObject(targetObject);
        }
        if (targetClass == null) {
            targetClass = targetObject.getClass();
        }
        if ((field = ReflectionUtils.findField(targetClass, name, type)) == null) {
            throw new IllegalArgumentException(String.format("Could not find field '%s' of type [%s] on %s or target class [%s]", name, type, ReflectionTestUtils.safeToString(targetObject), targetClass));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Setting field '%s' of type [%s] on %s or target class [%s] to value [%s]", name, type, ReflectionTestUtils.safeToString(targetObject), targetClass, value));
        }
        ReflectionUtils.makeAccessible(field);
        ReflectionUtils.setField(field, targetObject, value);
    }

    @Nullable
    public static Object getField(Object targetObject, String name) {
        return ReflectionTestUtils.getField(targetObject, null, name);
    }

    @Nullable
    public static Object getField(Class<?> targetClass, String name) {
        return ReflectionTestUtils.getField(null, targetClass, name);
    }

    @Nullable
    public static Object getField(@Nullable Object targetObject, @Nullable Class<?> targetClass, String name) {
        Field field;
        Assert.isTrue(targetObject != null || targetClass != null, "Either targetObject or targetClass for the field must be specified");
        if (targetObject != null && springAopPresent) {
            targetObject = AopTestUtils.getUltimateTargetObject(targetObject);
        }
        if (targetClass == null) {
            targetClass = targetObject.getClass();
        }
        if ((field = ReflectionUtils.findField(targetClass, name)) == null) {
            throw new IllegalArgumentException(String.format("Could not find field '%s' on %s or target class [%s]", name, ReflectionTestUtils.safeToString(targetObject), targetClass));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Getting field '%s' from %s or target class [%s]", name, ReflectionTestUtils.safeToString(targetObject), targetClass));
        }
        ReflectionUtils.makeAccessible(field);
        return ReflectionUtils.getField(field, targetObject);
    }

    public static void invokeSetterMethod(Object target, String name, Object value) {
        ReflectionTestUtils.invokeSetterMethod(target, name, value, null);
    }

    public static void invokeSetterMethod(Object target, String name, @Nullable Object value, @Nullable Class<?> type) {
        Method method2;
        Class[] classArray;
        Assert.notNull(target, "Target object must not be null");
        Assert.hasText(name, "Method name must not be empty");
        if (type != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type;
        } else {
            classArray = null;
        }
        Class[] paramTypes = classArray;
        String setterMethodName = name;
        if (!name.startsWith(SETTER_PREFIX)) {
            setterMethodName = SETTER_PREFIX + StringUtils.capitalize(name);
        }
        if ((method2 = ReflectionUtils.findMethod(target.getClass(), setterMethodName, paramTypes)) == null && !setterMethodName.equals(name)) {
            setterMethodName = name;
            method2 = ReflectionUtils.findMethod(target.getClass(), setterMethodName, paramTypes);
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Could not find setter method '%s' on %s with parameter type [%s]", setterMethodName, ReflectionTestUtils.safeToString(target), type));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Invoking setter method '%s' on %s with value [%s]", setterMethodName, ReflectionTestUtils.safeToString(target), value));
        }
        ReflectionUtils.makeAccessible(method2);
        ReflectionUtils.invokeMethod(method2, target, value);
    }

    @Nullable
    public static Object invokeGetterMethod(Object target, String name) {
        Method method2;
        Assert.notNull(target, "Target object must not be null");
        Assert.hasText(name, "Method name must not be empty");
        String getterMethodName = name;
        if (!name.startsWith(GETTER_PREFIX)) {
            getterMethodName = GETTER_PREFIX + StringUtils.capitalize(name);
        }
        if ((method2 = ReflectionUtils.findMethod(target.getClass(), getterMethodName)) == null && !getterMethodName.equals(name)) {
            getterMethodName = name;
            method2 = ReflectionUtils.findMethod(target.getClass(), getterMethodName);
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Could not find getter method '%s' on %s", getterMethodName, ReflectionTestUtils.safeToString(target)));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Invoking getter method '%s' on %s", getterMethodName, ReflectionTestUtils.safeToString(target)));
        }
        ReflectionUtils.makeAccessible(method2);
        return ReflectionUtils.invokeMethod(method2, target);
    }

    @Nullable
    public static <T> T invokeMethod(Object target, String name, Object ... args) {
        Assert.notNull(target, "Target object must not be null");
        Assert.hasText(name, "Method name must not be empty");
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetObject(target);
            methodInvoker.setTargetMethod(name);
            methodInvoker.setArguments(args);
            methodInvoker.prepare();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Invoking method '%s' on %s with arguments %s", name, ReflectionTestUtils.safeToString(target), ObjectUtils.nullSafeToString(args)));
            }
            return (T)methodInvoker.invoke();
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    private static String safeToString(@Nullable Object target) {
        try {
            return String.format("target object [%s]", target);
        }
        catch (Exception ex) {
            return String.format("target of type [%s] whose toString() method threw [%s]", target != null ? target.getClass().getName() : "unknown", ex);
        }
    }
}

