/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public abstract class AssertionErrors {
    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void fail(String message, @Nullable Object expected, @Nullable Object actual) {
        throw new AssertionError((Object)(message + " expected:<" + expected + "> but was:<" + actual + ">"));
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            AssertionErrors.fail(message);
        }
    }

    public static void assertEquals(String message, @Nullable Object expected, @Nullable Object actual) {
        if (!ObjectUtils.nullSafeEquals(expected, actual)) {
            AssertionErrors.fail(message, ObjectUtils.nullSafeToString(expected), ObjectUtils.nullSafeToString(actual));
        }
    }

    public static void assertNotEquals(String message, @Nullable Object expected, @Nullable Object actual) {
        if (ObjectUtils.nullSafeEquals(expected, actual)) {
            throw new AssertionError((Object)(message + " was not expected to be:<" + ObjectUtils.nullSafeToString(actual) + ">"));
        }
    }
}

