/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit.jupiter;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit.jupiter.ParameterAutowireUtils;
import org.springframework.util.Assert;

public class SpringExtension
implements BeforeAllCallback,
AfterAllCallback,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SpringExtension.class});

    public void beforeAll(ExtensionContext context) throws Exception {
        SpringExtension.getTestContextManager(context).beforeTestClass();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        try {
            SpringExtension.getTestContextManager(context).afterTestClass();
        }
        finally {
            SpringExtension.getStore(context).remove((Object)context.getRequiredTestClass());
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        SpringExtension.getTestContextManager(context).prepareTestInstance(testInstance);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        SpringExtension.getTestContextManager(context).beforeTestMethod(testInstance, testMethod);
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        SpringExtension.getTestContextManager(context).beforeTestExecution(testInstance, testMethod);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        Throwable testException = context.getExecutionException().orElse(null);
        SpringExtension.getTestContextManager(context).afterTestExecution(testInstance, testMethod, testException);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        Throwable testException = context.getExecutionException().orElse(null);
        SpringExtension.getTestContextManager(context).afterTestMethod(testInstance, testMethod, testException);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        int index = parameterContext.getIndex();
        Executable executable = parameter.getDeclaringExecutable();
        return executable instanceof Constructor && AnnotatedElementUtils.hasAnnotation(executable, Autowired.class) || ParameterAutowireUtils.isAutowirable(parameter, index);
    }

    @Nullable
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        int index = parameterContext.getIndex();
        Class testClass = extensionContext.getRequiredTestClass();
        ApplicationContext applicationContext = SpringExtension.getApplicationContext(extensionContext);
        return ParameterAutowireUtils.resolveDependency(parameter, index, testClass, applicationContext);
    }

    public static ApplicationContext getApplicationContext(ExtensionContext context) {
        return SpringExtension.getTestContextManager(context).getTestContext().getApplicationContext();
    }

    private static TestContextManager getTestContextManager(ExtensionContext context) {
        Assert.notNull((Object)context, "ExtensionContext must not be null");
        Class testClass = context.getRequiredTestClass();
        ExtensionContext.Store store = SpringExtension.getStore(context);
        return (TestContextManager)store.getOrComputeIfAbsent((Object)testClass, TestContextManager::new, TestContextManager.class);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

